/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.io.IOUtils;
import org.archive.bdb.AutoKryo;
import org.archive.modules.CrawlURI;
import org.archive.modules.credential.Credential;
import org.archive.modules.fetcher.FetchStats;
import org.archive.modules.net.Robotstxt;
import org.archive.net.UURI;
import org.archive.util.IdentityCacheable;
import org.archive.util.ObjectIdentityCache;

public class CrawlServer
implements Serializable,
FetchStats.HasFetchStats,
IdentityCacheable {
    private static final Logger logger = Logger.getLogger(CrawlServer.class.getName());
    private static final long serialVersionUID = 3L;
    public static final long ROBOTS_NOT_FETCHED = -1L;
    public static final long MIN_ROBOTS_RETRIES = 3L;
    private String server;
    private int port;
    protected Robotstxt robotstxt;
    protected long robotsFetched = -1L;
    protected boolean validRobots = false;
    protected FetchStats substats = new FetchStats();
    protected int consecutiveConnectionErrors = 0;
    private transient Set<Credential> credentials = null;
    private transient ObjectIdentityCache<?> cache;
    private transient Map<String, String> httpAuthChallenges;

    public CrawlServer(String h) {
        this.server = h;
        int colonIndex = this.server.lastIndexOf(":");
        if (colonIndex < 0) {
            this.port = -1;
        } else {
            try {
                this.port = Integer.parseInt(this.server.substring(colonIndex + 1));
            }
            catch (NumberFormatException e) {
                this.port = -1;
            }
        }
    }

    public String toString() {
        return "CrawlServer(" + this.server + ")";
    }

    public int hashCode() {
        return this.server != null ? this.server.hashCode() : 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CrawlServer other = (CrawlServer)obj;
        return this.server == other.server || this.server != null && this.server.equals(other.server);
    }

    public Robotstxt getRobotstxt() {
        return this.robotstxt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateRobots(CrawlURI curi) {
        this.robotsFetched = System.currentTimeMillis();
        if ((curi.getFetchType() != CrawlURI.FetchType.HTTP_GET || curi.getFetchStatus() <= 0 && curi.getFetchStatus() != -404) && (long)curi.getFetchAttempts() < 3L) {
            this.validRobots = false;
            return;
        }
        int fetchStatus = curi.getFetchStatus();
        if (fetchStatus < 200 || fetchStatus >= 300) {
            this.robotstxt = Robotstxt.NO_ROBOTS;
            this.validRobots = true;
            return;
        }
        InputStream contentBodyStream = null;
        try {
            contentBodyStream = curi.getRecorder().getContentReplayInputStream();
            InputStreamReader reader = new InputStreamReader(contentBodyStream);
            this.robotstxt = new Robotstxt(reader);
            this.validRobots = true;
        }
        catch (IOException e) {
            this.robotstxt = Robotstxt.NO_ROBOTS;
            logger.log(Level.WARNING, "problem reading robots.txt for " + curi, e);
            this.validRobots = true;
            curi.getNonFatalFailures().add(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentBodyStream);
        }
    }

    public String getName() {
        return this.server;
    }

    public int getPort() {
        return this.port;
    }

    public void incrementConsecutiveConnectionErrors() {
        ++this.consecutiveConnectionErrors;
    }

    public void resetConsecutiveConnectionErrors() {
        this.consecutiveConnectionErrors = 0;
    }

    public Set<Credential> getCredentials() {
        return this.credentials;
    }

    public boolean hasCredentials() {
        return this.credentials != null && this.credentials.size() > 0;
    }

    public void addCredential(Credential cred) {
        if (this.credentials == null) {
            this.credentials = new HashSet<Credential>();
        }
        this.credentials.add(cred);
    }

    public synchronized boolean isValidRobots() {
        return this.validRobots;
    }

    public static String getServerKey(UURI uuri) throws URIException {
        String key = uuri.getAuthorityMinusUserinfo();
        if (key == null && (key = uuri.getCurrentHierPath()) != null && !key.matches("[-_\\w\\.:]+")) {
            key = null;
        }
        if (key != null && uuri.getScheme().equals("https") && !key.matches(".+:[0-9]+")) {
            key = key + ":443";
        }
        return key;
    }

    @Override
    public FetchStats getSubstats() {
        return this.substats;
    }

    public synchronized boolean isRobotsExpired(int validityDuration) {
        if (this.robotsFetched == -1L) {
            return true;
        }
        long duration = (long)validityDuration * 1000L;
        if (duration == 0L) {
            return false;
        }
        return this.robotsFetched + duration < System.currentTimeMillis();
    }

    public static void autoregisterTo(AutoKryo kryo) {
        kryo.register(CrawlServer.class);
        kryo.autoregister(FetchStats.class);
        kryo.autoregister(Robotstxt.class);
    }

    public String getKey() {
        return this.getName();
    }

    public void makeDirty() {
        this.cache.dirtyKey(this.getKey());
    }

    public void setIdentityCache(ObjectIdentityCache<?> cache) {
        this.cache = cache;
    }

    public Map<String, String> getHttpAuthChallenges() {
        return this.httpAuthChallenges;
    }

    public void setHttpAuthChallenges(Map<String, String> httpAuthChallenges) {
        this.httpAuthChallenges = httpAuthChallenges;
    }
}

