/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.net;

import java.io.Serializable;
import java.util.concurrent.ConcurrentSkipListSet;
import org.archive.bdb.AutoKryo;

public class RobotsDirectives
implements Serializable {
    private static final long serialVersionUID = 5386542759286155383L;
    protected ConcurrentSkipListSet<String> disallows = new ConcurrentSkipListSet();
    protected ConcurrentSkipListSet<String> allows = new ConcurrentSkipListSet();
    protected float crawlDelay = -1.0f;
    public transient boolean hasDirectives = false;

    public boolean allows(String path) {
        return this.longestPrefixLength(this.disallows, path) <= this.longestPrefixLength(this.allows, path);
    }

    protected int longestPrefixLength(ConcurrentSkipListSet<String> prefixSet, String str) {
        String possiblePrefix = prefixSet.floor(str);
        if (possiblePrefix != null && str.startsWith(possiblePrefix)) {
            return possiblePrefix.length();
        }
        return 0;
    }

    public void addDisallow(String path) {
        this.hasDirectives = true;
        if (path.length() == 0) {
            return;
        }
        this.disallows.add(path);
    }

    public void addAllow(String path) {
        this.hasDirectives = true;
        this.allows.add(path);
    }

    public void setCrawlDelay(float i) {
        this.hasDirectives = true;
        this.crawlDelay = i;
    }

    public float getCrawlDelay() {
        return this.crawlDelay;
    }

    public static void autoregisterTo(AutoKryo kryo) {
        kryo.register(RobotsDirectives.class);
        kryo.useReferencesFor(RobotsDirectives.class);
        kryo.autoregister(ConcurrentSkipListSet.class);
    }
}

