/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.net;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.URIException;
import org.archive.modules.CrawlURI;
import org.archive.modules.net.IgnoreRobotsPolicy;
import org.archive.modules.net.ObeyRobotsPolicy;
import org.archive.modules.net.RobotsTxtOnlyPolicy;
import org.archive.modules.net.Robotstxt;

public abstract class RobotsPolicy {
    public static Map<String, RobotsPolicy> STANDARD_POLICIES = new HashMap<String, RobotsPolicy>();

    public abstract boolean allows(String var1, CrawlURI var2, Robotstxt var3);

    public abstract boolean obeyMetaRobotsNofollow();

    public String getPathQuery(CrawlURI curi) {
        try {
            return curi.getUURI().getPathQuery();
        }
        catch (URIException e) {
            return "";
        }
    }

    static {
        STANDARD_POLICIES.put("obey", ObeyRobotsPolicy.INSTANCE);
        STANDARD_POLICIES.put("classic", ObeyRobotsPolicy.INSTANCE);
        STANDARD_POLICIES.put("ignore", IgnoreRobotsPolicy.INSTANCE);
        STANDARD_POLICIES.put("robotsTxtOnly", RobotsTxtOnlyPolicy.INSTANCE);
    }
}

