/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.net;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.Buffer;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.archive.bdb.AutoKryo;
import org.archive.io.ReadSource;
import org.archive.modules.net.RobotsDirectives;

public class Robotstxt
implements Serializable {
    static final long serialVersionUID = 7025386509301303890L;
    private static final Logger logger = Logger.getLogger(Robotstxt.class.getName());
    protected static final int MAX_SIZE = 512000;
    private static final Pattern LINE_SEPARATOR = Pattern.compile("\r\n|\r|\n");
    protected LinkedList<String> namedUserAgents = new LinkedList();
    protected Map<String, RobotsDirectives> agentsToDirectives = new HashMap<String, RobotsDirectives>();
    protected RobotsDirectives wildcardDirectives = null;
    protected boolean hasErrors = false;
    protected static RobotsDirectives NO_DIRECTIVES = new RobotsDirectives();
    public static Robotstxt NO_ROBOTS = new Robotstxt();

    public Robotstxt() {
    }

    public Robotstxt(Reader reader) throws IOException {
        try {
            this.initializeFromReader(reader);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Robotstxt(ReadSource customRobots) {
        Reader reader = customRobots.obtainReader();
        try {
            this.initializeFromReader(reader);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "robots ReadSource problem: potential for inadvertent overcrawling", e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    protected void initializeFromReader(Reader reader) throws IOException {
        CharBuffer buffer = CharBuffer.allocate(512000);
        while (buffer.hasRemaining() && reader.read(buffer) >= 0) {
        }
        ((Buffer)buffer).flip();
        String[] lines = LINE_SEPARATOR.split(buffer);
        if (buffer.limit() == buffer.capacity()) {
            int processed = buffer.capacity();
            if (lines.length != 0) {
                int last = lines.length - 1;
                processed -= lines[last].length();
                lines[last] = "";
            }
            logger.warning("processed " + processed + " characters, ignoring the rest (see HER-1990)");
        }
        RobotsDirectives current = null;
        for (String read : lines) {
            String path;
            if ((read = read.trim()).isEmpty() || read.startsWith("#")) continue;
            int commentIndex = (read = read.replaceAll("<[^>]+>", "")).indexOf("#");
            if (commentIndex > -1) {
                read = read.substring(0, commentIndex);
            }
            if ((read = read.trim()).matches("(?i)^User-agent:.*")) {
                String ua = read.substring(11).trim().toLowerCase();
                RobotsDirectives preexisting = ua.equals("*") ? this.wildcardDirectives : this.agentsToDirectives.get(ua);
                if (preexisting != null && preexisting.hasDirectives) {
                    current = preexisting;
                } else if (current == null || current.hasDirectives) {
                    current = new RobotsDirectives();
                }
                if (ua.equals("*")) {
                    this.wildcardDirectives = current;
                    continue;
                }
                this.namedUserAgents.addLast(ua);
                this.agentsToDirectives.put(ua, current);
                continue;
            }
            if (read.matches("(?i)Disallow:.*")) {
                if (current == null) {
                    this.hasErrors = true;
                    continue;
                }
                path = read.substring(9).trim();
                if (path.endsWith("*")) {
                    path = path.substring(0, path.length() - 1);
                }
                current.addDisallow(path);
                continue;
            }
            if (read.matches("(?i)Crawl-delay:.*")) {
                if (current == null) {
                    this.hasErrors = true;
                    continue;
                }
                String val = read.substring(12).trim();
                try {
                    val = val.split("[^\\d\\.]+")[0];
                    current.setCrawlDelay(Float.parseFloat(val));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!read.matches("(?i)Allow:.*")) continue;
            if (current == null) {
                this.hasErrors = true;
                continue;
            }
            path = read.substring(6).trim();
            if (path.endsWith("*")) {
                path = path.substring(0, path.length() - 1);
            }
            current.addAllow(path);
        }
    }

    public boolean allowsAll() {
        return this.agentsToDirectives.isEmpty();
    }

    public List<String> getNamedUserAgents() {
        return this.namedUserAgents;
    }

    public RobotsDirectives getDirectivesFor(String ua, boolean useFallbacks) {
        for (String uaListed : this.namedUserAgents) {
            if (ua.indexOf(uaListed) <= -1) continue;
            return this.agentsToDirectives.get(uaListed);
        }
        if (!useFallbacks) {
            return null;
        }
        if (this.wildcardDirectives != null) {
            return this.wildcardDirectives;
        }
        return NO_DIRECTIVES;
    }

    public RobotsDirectives getDirectivesFor(String userAgent) {
        return this.getDirectivesFor(userAgent, true);
    }

    public static void autoregisterTo(AutoKryo kryo) {
        kryo.register(Robotstxt.class);
        kryo.autoregister(HashMap.class);
        kryo.autoregister(LinkedList.class);
        kryo.autoregister(RobotsDirectives.class);
    }
}

