/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.net;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections.Closure;
import org.apache.commons.httpclient.URIException;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.CrawlServer;
import org.archive.net.UURI;

public abstract class ServerCache {
    private static Logger logger = Logger.getLogger(ServerCache.class.getName());

    public abstract CrawlHost getHostFor(String var1);

    public abstract CrawlServer getServerFor(String var1);

    public abstract void forAllHostsDo(Closure var1);

    public CrawlHost getHostFor(UURI uuri) {
        CrawlHost h = null;
        try {
            h = uuri.getScheme().equals("dns") ? this.getHostFor("dns:") : (uuri.getScheme().equals("whois") ? this.getHostFor("whois:") : this.getHostFor(uuri.getReferencedHost()));
        }
        catch (URIException e) {
            logger.log(Level.SEVERE, uuri.toString(), e);
        }
        return h;
    }

    public CrawlServer getServerFor(UURI uuri) {
        CrawlServer cs = null;
        try {
            String key = CrawlServer.getServerKey(uuri);
            if (key != null) {
                cs = this.getServerFor(key);
            }
        }
        catch (URIException e) {
            logger.log(Level.FINE, "No server key obtainable: " + uuri.toString(), e);
        }
        catch (NullPointerException npe) {
            logger.log(Level.FINE, "No server key obtainable: " + uuri.toString(), npe);
        }
        return cs;
    }

    public abstract Set<String> hostKeys();
}

