/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.recrawl;

import org.archive.modules.CrawlURI;
import org.archive.modules.Processor;

public abstract class AbstractPersistProcessor
extends Processor {
    protected boolean onlyStoreIfWriteTagPresent = true;

    public boolean getOnlyStoreIfWriteTagPresent() {
        return this.onlyStoreIfWriteTagPresent;
    }

    public void setOnlyStoreIfWriteTagPresent(boolean onlyStoreIfWriteTagPresent) {
        this.onlyStoreIfWriteTagPresent = onlyStoreIfWriteTagPresent;
    }

    protected boolean shouldStore(CrawlURI curi) {
        if (!curi.isSuccess()) {
            return false;
        }
        String scheme = curi.getUURI().getScheme();
        if (!(scheme.equals("http") || scheme.equals("https") || scheme.equals("ftp") || scheme.equals("sftp"))) {
            return false;
        }
        return !this.getOnlyStoreIfWriteTagPresent() || this.hasWriteTag(curi);
    }

    protected boolean hasWriteTag(CrawlURI uri) {
        return uri.getFetchHistory() != null && uri.getFetchHistory()[0] != null && uri.getFetchHistory()[0].containsKey("write-tag");
    }

    protected boolean shouldLoad(CrawlURI curi) {
        return true;
    }
}

