/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.recrawl;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.bdb.BdbModule;
import org.archive.modules.CrawlURI;
import org.archive.modules.recrawl.AbstractContentDigestHistory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.Lifecycle;

public class BdbContentDigestHistory
extends AbstractContentDigestHistory
implements Lifecycle {
    private static final Logger logger = Logger.getLogger(BdbContentDigestHistory.class.getName());
    protected BdbModule bdb;
    protected String historyDbName = "contentDigestHistory";
    protected StoredSortedMap<String, Map> store;
    protected Database historyDb;
    protected transient BdbModule.BdbConfig historyDbConfig;

    @Autowired
    public void setBdbModule(BdbModule bdb) {
        this.bdb = bdb;
    }

    public String getHistoryDbName() {
        return this.historyDbName;
    }

    public void setHistoryDbName(String name) {
        this.historyDbName = name;
    }

    public void start() {
        StoredSortedMap historyMap;
        if (this.isRunning()) {
            return;
        }
        try {
            StoredClassCatalog classCatalog = this.bdb.getClassCatalog();
            this.historyDb = this.bdb.openDatabase(this.getHistoryDbName(), this.historyDbConfig(), true);
            historyMap = new StoredSortedMap(this.historyDb, (EntryBinding)new StringBinding(), (EntryBinding)new SerialBinding((ClassCatalog)classCatalog, Map.class), true);
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
        this.store = historyMap;
    }

    public boolean isRunning() {
        return this.historyDb != null;
    }

    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.historyDb = null;
    }

    protected BdbModule.BdbConfig historyDbConfig() {
        if (this.historyDbConfig == null) {
            this.historyDbConfig = new BdbModule.BdbConfig();
            this.historyDbConfig.setTransactional(false);
            this.historyDbConfig.setAllowCreate(true);
            this.historyDbConfig.setDeferredWrite(true);
        }
        return this.historyDbConfig;
    }

    @Override
    public void load(CrawlURI curi) {
        HashMap<String, Object> contentDigestHistory = curi.getContentDigestHistory();
        Map loadedHistory = (Map)this.store.get((Object)this.persistKeyFor(curi));
        if (loadedHistory != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("loaded history by digest " + this.persistKeyFor(curi) + " for uri " + curi + " - " + loadedHistory);
            }
            contentDigestHistory.putAll(loadedHistory);
        }
    }

    @Override
    public void store(CrawlURI curi) {
        if (!curi.hasContentDigestHistory() || curi.getContentDigestHistory().isEmpty()) {
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("storing history by digest " + this.persistKeyFor(curi) + " for uri " + curi + " - " + curi.getContentDigestHistory());
        }
        this.store.put((Object)this.persistKeyFor(curi), curi.getContentDigestHistory());
    }
}

