/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.recrawl;

import org.archive.modules.CrawlURI;
import org.archive.modules.Processor;
import org.archive.modules.recrawl.AbstractContentDigestHistory;
import org.archive.modules.revisit.IdenticalPayloadDigestRevisit;
import org.springframework.beans.factory.annotation.Autowired;

public class ContentDigestHistoryLoader
extends Processor {
    protected AbstractContentDigestHistory contentDigestHistory;

    @Autowired
    public void setContentDigestHistory(AbstractContentDigestHistory contentDigestHistory) {
        this.contentDigestHistory = contentDigestHistory;
    }

    @Override
    protected boolean shouldProcess(CrawlURI uri) {
        return uri.getContentDigest() != null && uri.getContentLength() > 0L;
    }

    @Override
    protected void innerProcess(CrawlURI curi) throws InterruptedException {
        this.contentDigestHistory.load(curi);
        if (!curi.getContentDigestHistory().isEmpty()) {
            IdenticalPayloadDigestRevisit revisit = new IdenticalPayloadDigestRevisit(curi.getContentDigestSchemeString());
            revisit.setRefersToDate((String)curi.getContentDigestHistory().get("content-written-date"));
            revisit.setRefersToTargetURI((String)curi.getContentDigestHistory().get("original-url"));
            String warcRecordId = (String)curi.getContentDigestHistory().get("warc-record-id");
            if (warcRecordId != null) {
                revisit.setRefersToRecordID(warcRecordId);
            }
            curi.setRevisitProfile(revisit);
            curi.getAnnotations().add("duplicate:digest");
        }
    }
}

