/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.recrawl;

import java.util.HashMap;
import java.util.Map;
import org.archive.modules.CrawlURI;
import org.archive.modules.Processor;
import org.archive.modules.revisit.IdenticalPayloadDigestRevisit;
import org.archive.modules.revisit.ServerNotModifiedRevisit;

public class FetchHistoryProcessor
extends Processor {
    private static final long serialVersionUID = 1L;
    protected int historyLength = 2;

    public int getHistoryLength() {
        return this.historyLength;
    }

    public void setHistoryLength(int length) {
        this.historyLength = length;
    }

    @Override
    protected void innerProcess(CrawlURI puri) throws InterruptedException {
        CrawlURI curi = puri;
        HashMap<String, Object> latestFetch = new HashMap<String, Object>();
        latestFetch.put("status", curi.getFetchStatus());
        latestFetch.put("fetch-began-time", curi.getFetchBeginTime());
        String digest = curi.getContentDigestSchemeString();
        if (digest != null) {
            latestFetch.put("content-digest", digest);
        }
        if (curi.isHttpTransaction()) {
            this.saveHeader(curi, latestFetch, "etag");
            this.saveHeader(curi, latestFetch, "last-modified");
            long referenceLength = curi.containsDataKey("reference-length") ? ((Long)curi.getData().get("reference-length")).longValue() : curi.getContentLength();
            latestFetch.put("reference-length", referenceLength);
        }
        HashMap<String, Object>[] history = this.historyRealloc(curi);
        for (int i = history.length - 1; i > 0; --i) {
            history[i] = history[i - 1];
        }
        history[0] = latestFetch;
        curi.setFetchHistory(history);
        if (curi.getFetchStatus() == 304) {
            if (history.length >= 2 && history[1] != null && history[1].containsKey("content-digest")) {
                latestFetch.put("content-digest", history[1].get("content-digest"));
                curi.getAnnotations().add("duplicate:server-not-modified");
                ServerNotModifiedRevisit revisit = new ServerNotModifiedRevisit();
                revisit.setETag((String)latestFetch.get("etag"));
                revisit.setLastModified((String)latestFetch.get("last-modified"));
                revisit.setPayloadDigest((String)latestFetch.get("content-digest"));
                curi.setRevisitProfile(revisit);
            }
        } else if (FetchHistoryProcessor.hasIdenticalDigest(curi)) {
            curi.getAnnotations().add("duplicate:digest");
            IdenticalPayloadDigestRevisit revisit = new IdenticalPayloadDigestRevisit((String)history[1].get("content-digest"));
            revisit.setRefersToTargetURI(curi.getURI());
            revisit.setRefersToDate((Long)history[1].get("fetch-began-time"));
            curi.setRevisitProfile(revisit);
        }
    }

    public static boolean hasIdenticalDigest(CrawlURI curi) {
        HashMap<String, Object>[] history = curi.getFetchHistory();
        return history != null && history[0] != null && history[0].containsKey("content-digest") && history[1] != null && history[1].containsKey("content-digest") && history[0].get("content-digest").equals(history[1].get("content-digest"));
    }

    protected HashMap<String, Object>[] historyRealloc(CrawlURI curi) {
        int targetHistoryLength = this.getHistoryLength();
        HashMap<String, Object>[] history = curi.getFetchHistory();
        if (history == null) {
            history = new HashMap[targetHistoryLength];
        }
        if (history.length != targetHistoryLength) {
            HashMap[] newHistory = new HashMap[targetHistoryLength];
            System.arraycopy(history, 0, newHistory, 0, Math.min(history.length, newHistory.length));
            history = newHistory;
        }
        return history;
    }

    protected void saveHeader(CrawlURI curi, Map<String, Object> map, String key) {
        String value = curi.getHttpResponseHeader(key);
        if (value != null) {
            map.put(key, value);
        }
    }

    @Override
    protected boolean shouldProcess(CrawlURI curi) {
        return curi.containsDataKey("fetch-began-time");
    }
}

