/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.recrawl;

import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.DatabaseException;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.archive.modules.CrawlURI;
import org.archive.modules.recrawl.PersistOnlineProcessor;
import org.archive.modules.recrawl.PersistProcessor;
import org.archive.spring.ConfigFile;
import org.archive.spring.ConfigPath;

public class PersistLoadProcessor
extends PersistOnlineProcessor {
    private static final long serialVersionUID = -1917169316015093131L;
    private static final Logger logger = Logger.getLogger(PersistLoadProcessor.class.getName());
    protected ConfigPath preloadSource = new ConfigFile("preload source", "");
    protected String preloadSourceUrl = "";

    public ConfigPath getPreloadSource() {
        return this.preloadSource;
    }

    public void setPreloadSource(ConfigPath preloadSource) {
        this.preloadSource = preloadSource;
    }

    public String getPreloadSourceUrl() {
        return this.preloadSourceUrl;
    }

    public void setPreloadSourceUrl(String preloadSourceUrl) {
        this.preloadSourceUrl = preloadSourceUrl;
    }

    @Override
    protected void innerProcess(CrawlURI curi) throws InterruptedException {
        String pkey = PersistLoadProcessor.persistKeyFor(curi);
        Map prior = (Map)this.store.get((Object)pkey);
        if (prior != null) {
            prior.keySet().removeAll(curi.getData().keySet());
            curi.getData().putAll(prior);
        }
    }

    @Override
    protected boolean shouldProcess(CrawlURI uri) {
        return this.shouldLoad(uri);
    }

    @Override
    public void start() {
        if (this.isRunning()) {
            return;
        }
        super.start();
        if (StringUtils.isNotBlank((String)this.getPreloadSourceUrl()) && StringUtils.isNotBlank((String)this.getPreloadSource().getPath())) {
            logger.log(Level.SEVERE, "Both preloadSource and preloadSourceUrl are set - using preloadSource " + this.getPreloadSource().getFile());
        }
        String source = null;
        Integer count = null;
        try {
            if (StringUtils.isNotBlank((String)this.getPreloadSource().getPath())) {
                source = this.preloadSource.getPath();
                count = PersistProcessor.copyPersistSourceToHistoryMap(this.preloadSource.getFile(), (StoredSortedMap<String, Map>)this.store);
            } else if (StringUtils.isNotBlank((String)this.getPreloadSourceUrl())) {
                source = this.getPreloadSourceUrl();
                count = PersistProcessor.copyPersistSourceToHistoryMap(new URL(source), (StoredSortedMap<String, Map>)this.store);
            }
            if (count != null) {
                logger.info("Loaded deduplication information for " + count + " previously fetched urls from " + source);
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "Problem loading " + source + ", proceeding without deduplication. " + ioe);
        }
        catch (DatabaseException de) {
            logger.log(Level.SEVERE, "Problem loading " + source + ", proceeding without deduplication. " + (Object)((Object)de));
        }
        catch (IllegalArgumentException iae) {
            logger.log(Level.SEVERE, "Problem loading " + source + ", proceeding without deduplication. " + iae);
        }
    }
}

