/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.recrawl;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.SerializationUtils;
import org.archive.checkpointing.Checkpoint;
import org.archive.checkpointing.Checkpointable;
import org.archive.io.CrawlerJournal;
import org.archive.modules.CrawlURI;
import org.archive.modules.recrawl.PersistProcessor;
import org.archive.spring.ConfigPath;
import org.springframework.context.Lifecycle;

public class PersistLogProcessor
extends PersistProcessor
implements Checkpointable,
Lifecycle {
    private static final long serialVersionUID = 1678691994065439346L;
    protected CrawlerJournal log;
    protected ConfigPath logFile = new ConfigPath("URI persistence log file", "${launchId}/logs/persistlog.txtser.gz");

    public ConfigPath getLogFile() {
        return this.logFile;
    }

    public void setLogFile(ConfigPath path) {
        this.logFile = path;
    }

    @Override
    public void start() {
        if (this.isRunning()) {
            return;
        }
        try {
            File logFile = this.getLogFile().getFile();
            this.log = new CrawlerJournal(logFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isRunning() {
        return this.log != null;
    }

    @Override
    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.log.close();
        this.log = null;
    }

    @Override
    protected void innerProcess(CrawlURI curi) {
        this.log.writeLine(new String[]{PersistLogProcessor.persistKeyFor(curi), " ", new String(Base64.encodeBase64((byte[])SerializationUtils.serialize((Serializable)((Serializable)((Object)curi.getData())))))});
    }

    @Override
    public void startCheckpoint(Checkpoint checkpointInProgress) {
    }

    @Override
    public void doCheckpoint(Checkpoint checkpointInProgress) throws IOException {
        this.log.rotateForCheckpoint(checkpointInProgress);
    }

    @Override
    public void finishCheckpoint(Checkpoint checkpointInProgress) {
    }

    @Override
    protected boolean shouldProcess(CrawlURI uri) {
        return this.shouldStore(uri);
    }
}

