/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.recrawl;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import java.util.Map;
import org.archive.bdb.BdbModule;
import org.archive.modules.recrawl.PersistProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.Lifecycle;

public abstract class PersistOnlineProcessor
extends PersistProcessor
implements Lifecycle {
    private static final long serialVersionUID = -666479480942267268L;
    protected BdbModule bdb;
    protected String historyDbName = "uri_history";
    protected StoredSortedMap<String, Map> store;
    protected Database historyDb;

    @Autowired
    public void setBdbModule(BdbModule bdb) {
        this.bdb = bdb;
    }

    public String getHistoryDbName() {
        return this.historyDbName;
    }

    public void setHistoryDbName(String name) {
        this.historyDbName = name;
    }

    @Override
    public void start() {
        StoredSortedMap historyMap;
        if (this.isRunning()) {
            return;
        }
        try {
            StoredClassCatalog classCatalog = this.bdb.getClassCatalog();
            BdbModule.BdbConfig dbConfig = HISTORY_DB_CONFIG;
            this.historyDb = this.bdb.openDatabase(this.getHistoryDbName(), dbConfig, true);
            historyMap = new StoredSortedMap(this.historyDb, (EntryBinding)new StringBinding(), (EntryBinding)new SerialBinding((ClassCatalog)classCatalog, Map.class), true);
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
        this.store = historyMap;
    }

    @Override
    public boolean isRunning() {
        return this.historyDb != null;
    }

    @Override
    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        this.historyDb = null;
    }
}

