/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.recrawl;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SerializationUtils;
import org.archive.bdb.BdbModule;
import org.archive.modules.CrawlURI;
import org.archive.modules.recrawl.AbstractPersistProcessor;
import org.archive.util.ArchiveUtils;
import org.archive.util.FileUtils;
import org.archive.util.OneLineSimpleLogger;
import org.archive.util.SURT;
import org.archive.util.bdbje.EnhancedEnvironment;
import org.archive.util.iterator.LineReadingIterator;
import org.json.JSONObject;

public abstract class PersistProcessor
extends AbstractPersistProcessor {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(PersistProcessor.class.getName());
    public static final String URI_HISTORY_DBNAME = "uri_history";
    public static final BdbModule.BdbConfig HISTORY_DB_CONFIG;

    public static String persistKeyFor(CrawlURI curi) {
        return PersistProcessor.persistKeyFor(curi.getUURI().toString());
    }

    public static String persistKeyFor(String uri) {
        return SURT.fromURI((String)uri, (boolean)true);
    }

    private static int copyPersistEnv(File sourceDir, StoredSortedMap<String, Map> historyMap) throws DatabaseException {
        int count = 0;
        EnhancedEnvironment sourceEnv = PersistProcessor.setupCopyEnvironment(sourceDir, true);
        StoredClassCatalog sourceClassCatalog = sourceEnv.getClassCatalog();
        DatabaseConfig historyDbConfig = HISTORY_DB_CONFIG.toDatabaseConfig();
        historyDbConfig.setReadOnly(true);
        Database sourceHistoryDB = sourceEnv.openDatabase(null, URI_HISTORY_DBNAME, historyDbConfig);
        StoredSortedMap sourceHistoryMap = new StoredSortedMap(sourceHistoryDB, (EntryBinding)new StringBinding(), (EntryBinding)new SerialBinding((ClassCatalog)sourceClassCatalog, Map.class), true);
        Iterator iter = sourceHistoryMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry item = (Map.Entry)iter.next();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine((String)item.getKey() + " " + new JSONObject((Map)item.getValue()));
            }
            if (historyMap != null) {
                historyMap.put(item.getKey(), item.getValue());
            }
            ++count;
        }
        StoredIterator.close(iter);
        sourceHistoryDB.close();
        sourceEnv.close();
        return count;
    }

    private static int populatePersistEnvFromLog(BufferedReader persistLogReader, StoredSortedMap<String, Map> historyMap) throws UnsupportedEncodingException, DatabaseException {
        int count = 0;
        LineReadingIterator iter = new LineReadingIterator(persistLogReader);
        while (iter.hasNext()) {
            Map alist;
            String line = (String)iter.next();
            if (line.length() == 0) continue;
            String[] splits = line.split(" ");
            if (splits.length != 2) {
                logger.severe("bad line has " + splits.length + " fields (should be 2): " + line);
                continue;
            }
            try {
                alist = (Map)SerializationUtils.deserialize((byte[])Base64.decodeBase64((byte[])splits[1].getBytes("UTF-8")));
            }
            catch (Exception e) {
                logger.severe("caught exception " + e + " deserializing line: " + line);
                continue;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(splits[0] + " " + ArchiveUtils.prettyString((Map)alist));
            }
            if (historyMap != null) {
                try {
                    historyMap.put((Object)splits[0], (Object)alist);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "caught exception after loading " + count + " urls from the persist log (perhaps crawl was stopped by user?)", e);
                    IOUtils.closeQuietly((Reader)persistLogReader);
                    return count;
                }
            }
            ++count;
        }
        IOUtils.closeQuietly((Reader)persistLogReader);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int populatePersistEnv(String sourcePath, File envFile) throws IOException {
        int count = 0;
        StoredSortedMap historyMap = null;
        EnhancedEnvironment targetEnv = null;
        StoredClassCatalog classCatalog = null;
        Database historyDB = null;
        if (envFile != null) {
            FileUtils.ensureWriteableDirectory((File)envFile);
            targetEnv = PersistProcessor.setupCopyEnvironment(envFile);
            classCatalog = targetEnv.getClassCatalog();
            historyDB = targetEnv.openDatabase(null, URI_HISTORY_DBNAME, HISTORY_DB_CONFIG.toDatabaseConfig());
            historyMap = new StoredSortedMap(historyDB, (EntryBinding)new StringBinding(), (EntryBinding)new SerialBinding((ClassCatalog)classCatalog, Map.class), true);
        }
        try {
            count = PersistProcessor.copyPersistSourceToHistoryMap(new File(sourcePath), historyMap);
        }
        finally {
            if (envFile != null) {
                logger.info(count + " records imported from " + sourcePath + " to BDB env " + envFile);
                historyDB.sync();
                historyDB.close();
                targetEnv.close();
            } else {
                logger.info(count + " records found in " + sourcePath);
            }
        }
        return count;
    }

    public static int copyPersistSourceToHistoryMap(File sourceFile, StoredSortedMap<String, Map> historyMap) throws DatabaseException, IOException {
        if (sourceFile.isDirectory()) {
            return PersistProcessor.copyPersistEnv(sourceFile, historyMap);
        }
        BufferedReader persistLogReader = ArchiveUtils.getBufferedReader((File)sourceFile);
        return PersistProcessor.populatePersistEnvFromLog(persistLogReader, historyMap);
    }

    public static int copyPersistSourceToHistoryMap(URL sourceUrl, StoredSortedMap<String, Map> historyMap) throws DatabaseException, IOException {
        BufferedReader persistLogReader = ArchiveUtils.getBufferedReader((URL)sourceUrl);
        return PersistProcessor.populatePersistEnvFromLog(persistLogReader, historyMap);
    }

    public static void main(String[] args) throws DatabaseException, IOException {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.ALL);
        handler.setFormatter((Formatter)new OneLineSimpleLogger());
        logger.addHandler(handler);
        logger.setUseParentHandlers(false);
        if (args.length == 2) {
            logger.setLevel(Level.INFO);
            PersistProcessor.populatePersistEnv(args[0], new File(args[1]));
        } else if (args.length == 1) {
            logger.setLevel(Level.FINE);
            PersistProcessor.populatePersistEnv(args[0], null);
        } else {
            System.out.println("Arguments: ");
            System.out.println("    source [target]");
            System.out.println("...where source is either a txtser log file or BDB env dir");
            System.out.println("and target, if present, is a BDB env dir. ");
            return;
        }
    }

    public static EnhancedEnvironment setupCopyEnvironment(File env) throws DatabaseException {
        return PersistProcessor.setupCopyEnvironment(env, false);
    }

    public static EnhancedEnvironment setupCopyEnvironment(File env, boolean readOnly) throws DatabaseException {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        envConfig.setReadOnly(readOnly);
        try {
            return new EnhancedEnvironment(env, envConfig);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("problem with specified environment " + env + "; is it already open?", iae);
        }
    }

    static {
        BdbModule.BdbConfig dbConfig = new BdbModule.BdbConfig();
        dbConfig.setTransactional(false);
        dbConfig.setAllowCreate(true);
        dbConfig.setDeferredWrite(true);
        HISTORY_DB_CONFIG = dbConfig;
    }
}

