/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.revisit;

import java.util.Map;
import org.archive.modules.revisit.AbstractProfile;

public class IdenticalPayloadDigestRevisit
extends AbstractProfile {
    protected final String payloadDigest;
    protected String refersToTargetURI;

    public IdenticalPayloadDigestRevisit(String payloadDigest) {
        if (payloadDigest == null) {
            throw new NullPointerException("PayloadDigest may not be null");
        }
        this.payloadDigest = payloadDigest;
    }

    @Override
    public String getProfileName() {
        return "http://netpreserve.org/warc/1.0/revisit/identical-payload-digest";
    }

    @Override
    public Map<String, String> getWarcHeaders() {
        Map<String, String> headers = super.getWarcHeaders();
        headers.put("WARC-Payload-Digest", this.payloadDigest);
        if (this.refersToTargetURI != null) {
            headers.put("WARC-Refers-To-Target-URI", this.refersToTargetURI);
        }
        return headers;
    }

    public String getRefersToTargetURI() {
        return this.refersToTargetURI;
    }

    public void setRefersToTargetURI(String refersToTargetURI) {
        this.refersToTargetURI = refersToTargetURI;
    }

    public String getPayloadDigest() {
        return this.payloadDigest;
    }
}

