/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.seeds;

import java.io.File;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.archive.modules.CrawlURI;
import org.archive.modules.seeds.SeedListener;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class SeedModule
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected boolean sourceTagSeeds = false;
    protected Set<SeedListener> seedListeners = new HashSet<SeedListener>();

    public boolean getSourceTagSeeds() {
        return this.sourceTagSeeds;
    }

    public void setSourceTagSeeds(boolean sourceTagSeeds) {
        this.sourceTagSeeds = sourceTagSeeds;
    }

    public Set<SeedListener> getSeedListeners() {
        return this.seedListeners;
    }

    @Autowired
    public void setSeedListeners(Set<SeedListener> seedListeners) {
        this.seedListeners.addAll(seedListeners);
    }

    protected void publishAddedSeed(CrawlURI curi) {
        for (SeedListener l : this.seedListeners) {
            l.addedSeed(curi);
        }
    }

    protected void publishNonSeedLine(String line) {
        for (SeedListener l : this.seedListeners) {
            l.nonseedLine(line);
        }
    }

    protected void publishConcludedSeedBatch() {
        for (SeedListener l : this.seedListeners) {
            l.concludedSeedBatch();
        }
    }

    public abstract void announceSeeds();

    public abstract void actOn(File var1);

    public abstract void addSeed(CrawlURI var1);

    public void addSeedListener(SeedListener sl) {
        this.seedListeners.add(sl);
    }
}

