/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.seeds;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.io.IOUtils;
import org.archive.io.ReadSource;
import org.archive.modules.CrawlURI;
import org.archive.modules.seeds.SeedModule;
import org.archive.net.UURI;
import org.archive.net.UURIFactory;
import org.archive.spring.WriteTarget;
import org.archive.util.ArchiveUtils;
import org.archive.util.DevUtils;
import org.archive.util.iterator.LineReadingIterator;
import org.archive.util.iterator.RegexLineIterator;
import org.springframework.beans.factory.annotation.Required;

public class TextSeedModule
extends SeedModule
implements ReadSource {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(TextSeedModule.class.getName());
    protected ReadSource textSource = null;
    protected int blockAwaitingSeedLines = -1;

    public ReadSource getTextSource() {
        return this.textSource;
    }

    @Required
    public void setTextSource(ReadSource seedsSource) {
        this.textSource = seedsSource;
    }

    public int getBlockAwaitingSeedLines() {
        return this.blockAwaitingSeedLines;
    }

    public void setBlockAwaitingSeedLines(int blockAwaitingSeedLines) {
        this.blockAwaitingSeedLines = blockAwaitingSeedLines;
    }

    @Override
    public void announceSeeds() {
        if (this.getBlockAwaitingSeedLines() > -1) {
            final CountDownLatch latch = new CountDownLatch(this.getBlockAwaitingSeedLines());
            new Thread(){

                @Override
                public void run() {
                    TextSeedModule.this.announceSeeds(latch);
                    while (latch.getCount() > 0L) {
                        latch.countDown();
                    }
                }
            }.start();
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.announceSeeds(null);
        }
    }

    protected void announceSeeds(CountDownLatch latchOrNull) {
        BufferedReader reader = new BufferedReader(this.textSource.obtainReader());
        try {
            this.announceSeedsFromReader(reader, latchOrNull);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    protected void announceSeedsFromReader(BufferedReader reader, CountDownLatch latchOrNull) {
        RegexLineIterator iter = new RegexLineIterator((Iterator)new LineReadingIterator(reader), "\\s*(#.*)?", "^[\\s\ufeff]*(\\S+)\\s*(#.*)?$", "$1");
        int count = 0;
        while (iter.hasNext()) {
            String s = (String)iter.next();
            if (Character.isLetterOrDigit(s.charAt(0))) {
                this.seedLine(s);
                if (++count % 20000 == 0) {
                    System.runFinalization();
                }
            } else {
                this.nonseedLine(s);
            }
            if (latchOrNull == null) continue;
            latchOrNull.countDown();
        }
        this.publishConcludedSeedBatch();
    }

    protected void seedLine(String uri) {
        String originalUri = uri;
        if (!uri.matches("[a-zA-Z][\\w+\\-]+:.*")) {
            uri = "http://" + uri;
        }
        try {
            UURI uuri = UURIFactory.getInstance((String)uri);
            CrawlURI curi = new CrawlURI(uuri);
            curi.setSeed(true);
            curi.setSchedulingDirective(2);
            if (this.getSourceTagSeeds()) {
                curi.setSourceTag(originalUri);
            }
            this.publishAddedSeed(curi);
        }
        catch (URIException e) {
            this.nonseedLine(uri);
        }
    }

    protected void nonseedLine(String line) {
        this.publishNonSeedLine(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actOn(File f) {
        BufferedReader reader = null;
        try {
            reader = ArchiveUtils.getBufferedReader((File)f);
            this.announceSeedsFromReader(reader, null);
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "problem reading seed file " + f, ioe);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
    }

    @Override
    public synchronized void addSeed(CrawlURI curi) {
        if (!(this.textSource instanceof WriteTarget)) {
            logger.warning("nowhere to log added seed: " + curi);
        } else {
            try {
                Writer fw = ((WriteTarget)this.textSource).obtainWriter(true);
                fw.write("\n");
                fw.write("# Heritrix added seed " + (curi.getVia() != null ? "redirect from " + curi.getVia() : "(JMX)") + ".\n");
                fw.write(curi.toString());
                fw.flush();
                fw.close();
            }
            catch (IOException e) {
                DevUtils.warnHandle((Throwable)e, (String)"problem writing new seed");
            }
        }
        this.publishAddedSeed(curi);
    }

    public Reader obtainReader() {
        return this.textSource.obtainReader();
    }
}

