/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.warc;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.archive.format.warc.WARCConstants;
import org.archive.io.ReplayInputStream;
import org.archive.io.warc.WARCRecordInfo;
import org.archive.modules.CrawlURI;
import org.archive.modules.warc.BaseWARCRecordBuilder;
import org.archive.util.ArchiveUtils;

public class DnsResponseRecordBuilder
extends BaseWARCRecordBuilder {
    @Override
    public boolean shouldBuildRecord(CrawlURI curi) {
        return "dns".equals(curi.getUURI().getScheme().toLowerCase());
    }

    @Override
    public WARCRecordInfo buildRecord(CrawlURI curi, URI concurrentTo) throws IOException {
        String timestamp = ArchiveUtils.getLog14Date((long)curi.getFetchBeginTime());
        WARCRecordInfo recordInfo = new WARCRecordInfo();
        recordInfo.setRecordId(DnsResponseRecordBuilder.generateRecordID());
        if (concurrentTo != null) {
            recordInfo.addExtraHeader("WARC-Concurrent-To", '<' + concurrentTo.toString() + '>');
        }
        recordInfo.setType(WARCConstants.WARCRecordType.response);
        recordInfo.setUrl(curi.toString());
        recordInfo.setCreate14DigitDate(timestamp);
        recordInfo.setMimetype(curi.getContentType());
        recordInfo.setContentLength(curi.getRecorder().getRecordedInput().getSize());
        recordInfo.setEnforceLength(true);
        if (curi.getServerIP() != null) {
            recordInfo.addExtraHeader("WARC-IP-Address", curi.getServerIP());
        }
        ReplayInputStream ris = curi.getRecorder().getRecordedInput().getReplayInputStream();
        recordInfo.setContentStream((InputStream)ris);
        return recordInfo;
    }
}

