/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.warc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.archive.format.warc.WARCConstants;
import org.archive.io.warc.WARCRecordInfo;
import org.archive.modules.CrawlURI;
import org.archive.modules.warc.BaseWARCRecordBuilder;
import org.archive.util.ArchiveUtils;

public class FtpControlConversationRecordBuilder
extends BaseWARCRecordBuilder {
    @Override
    public boolean shouldBuildRecord(CrawlURI curi) {
        return "ftp".equalsIgnoreCase(curi.getUURI().getScheme()) || "sftp".equalsIgnoreCase(curi.getUURI().getScheme());
    }

    @Override
    public WARCRecordInfo buildRecord(CrawlURI curi, URI concurrentTo) throws IOException {
        String timestamp = ArchiveUtils.getLog14Date((long)curi.getFetchBeginTime());
        String controlConversation = curi.getData().get("ftp-control-conversation").toString();
        WARCRecordInfo recordInfo = new WARCRecordInfo();
        recordInfo.setRecordId(FtpControlConversationRecordBuilder.generateRecordID());
        if (concurrentTo != null) {
            recordInfo.addExtraHeader("WARC-Concurrent-To", '<' + concurrentTo.toString() + '>');
        }
        recordInfo.setCreate14DigitDate(timestamp);
        recordInfo.setUrl(curi.toString());
        recordInfo.setMimetype("text/x-ftp-control-conversation");
        recordInfo.setEnforceLength(true);
        recordInfo.setType(WARCConstants.WARCRecordType.metadata);
        if (curi.getServerIP() != null) {
            recordInfo.addExtraHeader("WARC-IP-Address", curi.getServerIP());
        }
        byte[] b = controlConversation.getBytes("UTF-8");
        recordInfo.setContentStream((InputStream)new ByteArrayInputStream(b));
        recordInfo.setContentLength((long)b.length);
        return recordInfo;
    }
}

