/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.warc;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.archive.format.warc.WARCConstants;
import org.archive.io.ReplayInputStream;
import org.archive.io.warc.WARCRecordInfo;
import org.archive.modules.CrawlURI;
import org.archive.modules.warc.BaseWARCRecordBuilder;
import org.archive.util.ArchiveUtils;

public class HttpRequestRecordBuilder
extends BaseWARCRecordBuilder {
    @Override
    public boolean shouldBuildRecord(CrawlURI curi) {
        return curi.getUURI().getScheme().toLowerCase().startsWith("http");
    }

    @Override
    public WARCRecordInfo buildRecord(CrawlURI curi, URI concurrentTo) throws IOException {
        String timestamp = ArchiveUtils.getLog14Date((long)curi.getFetchBeginTime());
        WARCRecordInfo recordInfo = new WARCRecordInfo();
        recordInfo.setRecordId(HttpRequestRecordBuilder.generateRecordID());
        if (concurrentTo != null) {
            recordInfo.addExtraHeader("WARC-Concurrent-To", '<' + concurrentTo.toString() + '>');
        }
        recordInfo.setType(WARCConstants.WARCRecordType.request);
        recordInfo.setUrl(curi.toString());
        recordInfo.setCreate14DigitDate(timestamp);
        recordInfo.setMimetype("application/http; msgtype=request");
        recordInfo.setContentLength(curi.getRecorder().getRecordedOutput().getSize());
        recordInfo.setEnforceLength(true);
        ReplayInputStream ris = curi.getRecorder().getRecordedOutput().getReplayInputStream();
        recordInfo.setContentStream((InputStream)ris);
        return recordInfo;
    }
}

