/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.warc;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.archive.format.warc.WARCConstants;
import org.archive.io.ReplayInputStream;
import org.archive.io.warc.WARCRecordInfo;
import org.archive.modules.CrawlURI;
import org.archive.modules.warc.BaseWARCRecordBuilder;
import org.archive.util.ArchiveUtils;

public class HttpResponseRecordBuilder
extends BaseWARCRecordBuilder {
    @Override
    public boolean shouldBuildRecord(CrawlURI curi) {
        return !curi.isRevisit() && curi.getUURI().getScheme().toLowerCase().startsWith("http");
    }

    @Override
    public WARCRecordInfo buildRecord(CrawlURI curi, URI concurrentTo) throws IOException {
        String timestamp = ArchiveUtils.getLog14Date((long)curi.getFetchBeginTime());
        WARCRecordInfo recordInfo = new WARCRecordInfo();
        recordInfo.setRecordId(HttpResponseRecordBuilder.generateRecordID());
        if (concurrentTo != null) {
            recordInfo.addExtraHeader("WARC-Concurrent-To", '<' + concurrentTo.toString() + '>');
        }
        recordInfo.setType(WARCConstants.WARCRecordType.response);
        recordInfo.setUrl(curi.toString());
        recordInfo.setCreate14DigitDate(timestamp);
        recordInfo.setMimetype("application/http; msgtype=response");
        recordInfo.setContentLength(curi.getRecorder().getRecordedInput().getSize());
        recordInfo.setEnforceLength(true);
        if (curi.getContentDigest() != null) {
            recordInfo.addExtraHeader("WARC-Payload-Digest", curi.getContentDigestSchemeString());
        }
        if (curi.getServerIP() != null) {
            recordInfo.addExtraHeader("WARC-IP-Address", curi.getServerIP());
        }
        String value = null;
        Collection<String> anno = curi.getAnnotations();
        if (anno.contains("timeTrunc")) {
            value = "time";
        } else if (anno.contains("lenTrunc")) {
            value = "length";
        } else if (anno.contains("headerTrunc")) {
            value = "long-headers";
        }
        if (value != null) {
            recordInfo.addExtraHeader("WARC-Truncated", value);
        }
        if (curi.getData().containsKey("warc-response-headers")) {
            for (Object headerObj : curi.getDataList("warc-response-headers")) {
                String[] kv = StringUtils.split((String)((String)headerObj), (String)":", (int)2);
                recordInfo.addExtraHeader(kv[0].trim(), kv[1].trim());
            }
        }
        ReplayInputStream ris = curi.getRecorder().getRecordedInput().getReplayInputStream();
        recordInfo.setContentStream((InputStream)ris);
        return recordInfo;
    }
}

