/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.warc;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.archive.format.warc.WARCConstants;
import org.archive.io.ReplayInputStream;
import org.archive.io.warc.WARCRecordInfo;
import org.archive.modules.CrawlURI;
import org.archive.modules.revisit.RevisitProfile;
import org.archive.modules.warc.BaseWARCRecordBuilder;
import org.archive.util.ArchiveUtils;

public class RevisitRecordBuilder
extends BaseWARCRecordBuilder {
    @Override
    public boolean shouldBuildRecord(CrawlURI curi) {
        String scheme = curi.getUURI().getScheme().toLowerCase();
        return curi.isRevisit() && (scheme.startsWith("http") || scheme.equals("ftp") || scheme.equals("sftp"));
    }

    @Override
    public WARCRecordInfo buildRecord(CrawlURI curi, URI concurrentTo) throws IOException {
        String timestamp = ArchiveUtils.getLog14Date((long)curi.getFetchBeginTime());
        long revisedLength = 0L;
        if (curi.getRevisitProfile().getProfileName().equals("http://netpreserve.org/warc/1.0/revisit/identical-payload-digest")) {
            revisedLength = curi.getRecorder().getRecordedInput().getContentBegin();
            revisedLength = revisedLength > 0L ? revisedLength : curi.getRecorder().getRecordedInput().getSize();
        }
        WARCRecordInfo recordInfo = new WARCRecordInfo();
        recordInfo.setRecordId(RevisitRecordBuilder.generateRecordID());
        if (concurrentTo != null) {
            recordInfo.addExtraHeader("WARC-Concurrent-To", '<' + concurrentTo.toString() + '>');
        }
        recordInfo.setType(WARCConstants.WARCRecordType.revisit);
        recordInfo.setUrl(curi.toString());
        recordInfo.setCreate14DigitDate(timestamp);
        String scheme = curi.getUURI().getScheme().toLowerCase();
        if (scheme.startsWith("http")) {
            recordInfo.setMimetype("application/http; msgtype=response");
        }
        recordInfo.setContentLength(revisedLength);
        recordInfo.setEnforceLength(false);
        RevisitProfile revisitProfile = curi.getRevisitProfile();
        recordInfo.addExtraHeader("WARC-Profile", revisitProfile.getProfileName());
        recordInfo.addExtraHeader("WARC-Truncated", "length");
        Map<String, String> revisitHeaders = revisitProfile.getWarcHeaders();
        for (Map.Entry<String, String> entry : revisitHeaders.entrySet()) {
            recordInfo.addExtraHeader(entry.getKey(), entry.getValue());
        }
        ReplayInputStream ris = curi.getRecorder().getRecordedInput().getReplayInputStream();
        recordInfo.setContentStream((InputStream)ris);
        return recordInfo;
    }
}

