/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.writer;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.archive.io.ReplayInputStream;
import org.archive.io.WriterPool;
import org.archive.io.WriterPoolMember;
import org.archive.io.WriterPoolSettings;
import org.archive.io.arc.ARCWriter;
import org.archive.io.arc.ARCWriterPool;
import org.archive.modules.CrawlURI;
import org.archive.modules.ProcessResult;
import org.archive.modules.writer.WriterPoolProcessor;
import org.archive.spring.ConfigPath;
import org.archive.util.ArchiveUtils;

public class ARCWriterProcessor
extends WriterPoolProcessor {
    private static final String METADATA_TEMPLATE = ARCWriterProcessor.readMetadataTemplate();
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(ARCWriterProcessor.class.getName());
    private transient List<String> cachedMetadata;

    @Override
    public long getDefaultMaxFileSize() {
        return 100000000L;
    }

    @Override
    public List<ConfigPath> getDefaultStorePaths() {
        ArrayList<ConfigPath> paths = new ArrayList<ConfigPath>();
        paths.add(new ConfigPath("arcs default store path", "arcs"));
        return paths;
    }

    @Override
    protected void setupPool(AtomicInteger serialNo) {
        this.setPool((WriterPool)new ARCWriterPool(serialNo, (WriterPoolSettings)this, this.getPoolMaxActive(), this.getMaxWaitForIdleMs()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ProcessResult innerProcessResult(CrawlURI curi) {
        ReplayInputStream ris;
        block5: {
            long recordLength = ARCWriterProcessor.getRecordedSize(curi);
            ris = null;
            if (!this.shouldWrite(curi)) break block5;
            ris = curi.getRecorder().getRecordedInput().getReplayInputStream();
            ProcessResult processResult = this.write(curi, recordLength, (InputStream)ris, this.getHostAddress(curi));
            IOUtils.closeQuietly((InputStream)ris);
            return processResult;
        }
        try {
            logger.info("does not write " + curi.toString());
            this.copyForwardWriteTagIfDupe(curi);
        }
        catch (IOException e) {
            try {
                curi.getNonFatalFailures().add(e);
                logger.log(Level.SEVERE, "Failed write of Record: " + curi.toString(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ris);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)ris);
        }
        IOUtils.closeQuietly((InputStream)ris);
        return ProcessResult.PROCEED;
    }

    protected ProcessResult write(CrawlURI curi, long recordLength, InputStream in, String ip) throws IOException {
        WriterPoolMember writer = this.getPool().borrowFile();
        long position = writer.getPosition();
        writer.checkSize();
        if (writer.getPosition() != position) {
            this.addTotalBytesWritten(writer.getPosition() - position);
            position = writer.getPosition();
        }
        ARCWriter w = (ARCWriter)writer;
        try {
            if (in instanceof ReplayInputStream) {
                w.write(curi.toString(), curi.getContentType(), ip, curi.getFetchBeginTime(), recordLength, (InputStream)((ReplayInputStream)in));
            } else {
                w.write(curi.toString(), curi.getContentType(), ip, curi.getFetchBeginTime(), recordLength, in);
            }
        }
        catch (IOException e) {
            this.getPool().invalidateFile(writer);
            writer = null;
            throw e;
        }
        finally {
            if (writer != null) {
                this.addTotalBytesWritten(writer.getPosition() - position);
                this.getPool().returnFile(writer);
                String filename = writer.getFile().getName();
                if (filename.endsWith(".open")) {
                    filename = filename.substring(0, filename.length() - ".open".length());
                }
                curi.addExtraInfo("arcFilename", filename);
                HashMap<String, Object>[] history = curi.getFetchHistory();
                if (history != null && history[0] != null) {
                    history[0].put("write-tag", filename);
                }
            }
        }
        return this.checkBytesWritten();
    }

    @Override
    public List<String> getMetadata() {
        if (METADATA_TEMPLATE == null) {
            return null;
        }
        if (this.cachedMetadata != null) {
            return this.cachedMetadata;
        }
        String meta = METADATA_TEMPLATE;
        meta = ARCWriterProcessor.replace(meta, "${VERSION}", ArchiveUtils.VERSION);
        meta = ARCWriterProcessor.replace(meta, "${HOST}", ARCWriterProcessor.getHostName());
        if ((meta = ARCWriterProcessor.replace(meta, "${IP}", ARCWriterProcessor.getHostAddress())) != null) {
            meta = ARCWriterProcessor.replace(meta, "${JOB_NAME}", this.getMetadataProvider().getJobName());
            meta = ARCWriterProcessor.replace(meta, "${DESCRIPTION}", this.getMetadataProvider().getDescription());
            meta = ARCWriterProcessor.replace(meta, "${OPERATOR}", this.getMetadataProvider().getOperator());
            meta = ARCWriterProcessor.replace(meta, "${USER_AGENT}", this.getMetadataProvider().getUserAgent());
            meta = ARCWriterProcessor.replace(meta, "${FROM}", this.getMetadataProvider().getOperatorFrom());
            meta = ARCWriterProcessor.replace(meta, "${ROBOTS}", this.getMetadataProvider().getRobotsPolicyName());
        }
        this.cachedMetadata = Collections.singletonList(meta);
        return this.cachedMetadata;
    }

    private static String replace(String meta, String find, String replace) {
        replace = StringUtils.defaultString((String)replace);
        replace = StringEscapeUtils.escapeXml((String)replace);
        return meta.replace(find, replace);
    }

    private static String getHostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "Could not get local host name.", e);
            return "localhost";
        }
    }

    private static String getHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "Could not get local host address.", e);
            return "localhost";
        }
    }

    private static String readMetadataTemplate() {
        InputStream input = ARCWriterProcessor.class.getResourceAsStream("arc_metadata_template.xml");
        if (input == null) {
            logger.severe("No metadata template.");
            return null;
        }
        try {
            String string = IOUtils.toString((InputStream)input);
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }
}

