/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.management.AttributeNotFoundException;
import org.apache.commons.io.IOUtils;
import org.archive.io.RecordingInputStream;
import org.archive.io.ReplayInputStream;
import org.archive.modules.CrawlURI;
import org.archive.modules.Processor;
import org.archive.net.UURI;
import org.archive.spring.ConfigPath;
import org.archive.util.FileUtils;

public class MirrorWriterProcessor
extends Processor {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(MirrorWriterProcessor.class.getName());
    public static final String A_MIRROR_PATH = "mirror-path";
    private static final Pattern PATH_SEGMENT_RE = Pattern.compile("[^\\" + File.separator + "]+");
    private static final Pattern TOO_LONG_DIRECTORY_RE = Pattern.compile("[^\\" + File.separator + "].*");
    protected boolean caseSensitiveFilesystem = true;
    protected List<String> characterMap = new ArrayList<String>();
    protected List<String> contentTypeMap = new ArrayList<String>();
    protected String dotBegin = "%2E";
    protected String dotEnd = ".";
    protected String directoryFile = "index.html";
    protected boolean createHostDirectory = true;
    protected List<String> hostMap = new ArrayList<String>();
    protected int maxPathLength = 1023;
    protected int maxSegLength = 255;
    protected ConfigPath path = new ConfigPath("mirror writer top level directory", "${launchId}/mirror");
    protected boolean createPortDirectory = false;
    protected boolean suffixAtEnd = true;
    protected String tooLongDirectory = "LONG";
    protected List<String> underscoreSet = new ArrayList<String>();
    private static final Map<String, String> EMPTY_MAP = Collections.unmodifiableMap(new TreeMap());

    public boolean getCaseSensitiveFilesystem() {
        return this.caseSensitiveFilesystem;
    }

    public void setCaseSensitiveFilesystem(boolean sensitive) {
        this.caseSensitiveFilesystem = sensitive;
    }

    public List<String> getCharacterMap() {
        return this.characterMap;
    }

    public void setCharacterMap(List<String> list) {
        this.characterMap = list;
    }

    public List<String> getContentTypeMap() {
        return this.contentTypeMap;
    }

    public void setContentTypeMap(List<String> list) {
        this.contentTypeMap = list;
    }

    public String getDotBegin() {
        return this.dotBegin;
    }

    public void setDotBegin(String s) {
        this.validate(PATH_SEGMENT_RE, s);
        this.dotBegin = s;
    }

    protected void validate(Pattern pat, String s) {
        if (!pat.matcher(s).matches()) {
            throw new IllegalArgumentException("invalid value: " + s + " does not match " + pat.pattern());
        }
    }

    public String getDotEnd() {
        return this.dotEnd;
    }

    public void setDotEnd(String s) {
        this.validate(PATH_SEGMENT_RE, s);
        this.dotEnd = s;
    }

    public String getDirectoryFile() {
        return this.directoryFile;
    }

    public void setDirectoryFile(String s) {
        this.validate(PATH_SEGMENT_RE, s);
        this.directoryFile = s;
    }

    public boolean getCreateHostDirectory() {
        return this.createHostDirectory;
    }

    public void setCreateHostDirectory(boolean hostDir) {
        this.createHostDirectory = hostDir;
    }

    public List<String> getHostMap() {
        return this.hostMap;
    }

    public void setHostMap(List<String> list) {
        this.hostMap = list;
    }

    public int getMaxPathLength() {
        return this.maxPathLength;
    }

    public void setMaxPathLength(int max) {
        this.maxPathLength = max;
    }

    public int getMaxSegLength() {
        return this.maxSegLength;
    }

    public void setMaxSegLength(int max) {
        this.maxSegLength = max;
    }

    public ConfigPath getPath() {
        return this.path;
    }

    public void setPath(ConfigPath s) {
        this.path = s;
    }

    public boolean getCreatePortDirectory() {
        return this.createPortDirectory;
    }

    public void setCreatePortDirectory(boolean portDir) {
        this.createPortDirectory = portDir;
    }

    public boolean getSuffixAtEnd() {
        return this.suffixAtEnd;
    }

    public void setSuffixAtEnd(boolean suffixAtEnd) {
        this.suffixAtEnd = suffixAtEnd;
    }

    public String getTooLongDirectory() {
        return this.tooLongDirectory;
    }

    public void setTooLongDirectory(String s) {
        this.validate(TOO_LONG_DIRECTORY_RE, s);
        this.tooLongDirectory = s;
    }

    public List<String> getUnderscoreSet() {
        return this.underscoreSet;
    }

    public void setUnderscoreSet(List<String> list) {
        this.underscoreSet = list;
    }

    @Override
    protected boolean shouldProcess(CrawlURI curi) {
        return MirrorWriterProcessor.isSuccess(curi);
    }

    @Override
    protected void innerProcess(CrawlURI curi) {
        UURI uuri = curi.getUURI();
        String scheme = uuri.getScheme();
        if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
            return;
        }
        RecordingInputStream recis = curi.getRecorder().getRecordedInput();
        if (0L == recis.getResponseContentLength()) {
            return;
        }
        String baseDir = this.getPath().getFile().getAbsolutePath();
        boolean reCrawl = curi.getData().containsKey(A_MIRROR_PATH);
        String mps = null;
        File destFile = null;
        try {
            if (reCrawl) {
                mps = (String)curi.getData().get(A_MIRROR_PATH);
                destFile = new File(baseDir + File.separator + mps);
                File parent = destFile.getParentFile();
                if (null != parent) {
                    FileUtils.ensureWriteableDirectory((File)parent);
                }
            } else {
                URIToFileReturn r = null;
                try {
                    r = this.uriToFile(baseDir, curi);
                }
                catch (AttributeNotFoundException e) {
                    logger.warning(e.getLocalizedMessage());
                    return;
                }
                destFile = r.getFile();
                mps = r.getRelativePath();
            }
            logger.info(uuri.toString() + " -> " + destFile.getPath());
            this.writeToPath(recis, destFile);
            if (!reCrawl) {
                curi.getData().put(A_MIRROR_PATH, mps);
            }
        }
        catch (IOException e) {
            curi.getNonFatalFailures().add(e);
        }
    }

    private URIToFileReturn dirPath(String baseDir, String host, int port, PathSegment[] segs, int maxLen) throws IOException {
        URIToFileReturn r = new URIToFileReturn(baseDir, host, port);
        r.mkdirs();
        for (int i = 0; segs.length - 1 != i; ++i) {
            segs[i].addToPath(r);
            if (!r.longerThan(maxLen)) continue;
            return null;
        }
        return r;
    }

    private void ensurePairs(List<?> list) {
        if (1 == list.size() % 2) {
            list.remove(list.size() - 1);
        }
    }

    private URIToFileReturn uriToFile(String baseDir, CrawlURI curi) throws AttributeNotFoundException, IOException {
        String tld;
        String dotEnd;
        String dotBegin;
        int maxPathLen;
        int maxSegLen;
        UURI uuri = curi.getUURI();
        String host = null;
        boolean hd = this.getCreateHostDirectory();
        if (hd) {
            host = uuri.getHost();
            List<String> hostMap = this.getHostMap();
            if (null != hostMap && hostMap.size() > 1) {
                this.ensurePairs(hostMap);
                Iterator<String> i = hostMap.iterator();
                boolean more = true;
                while (more && i.hasNext()) {
                    String h1 = i.next();
                    String h2 = i.next();
                    if (!host.equalsIgnoreCase(h1)) continue;
                    more = false;
                    if (null == h2 || 0 == h2.length()) continue;
                    host = h2;
                }
            }
        }
        int port = this.getCreatePortDirectory() ? uuri.getPort() : -1;
        String suffix = null;
        List<String> ctm = this.getContentTypeMap();
        if (null != ctm && ctm.size() > 1) {
            this.ensurePairs(ctm);
            String contentType = curi.getContentType().toLowerCase();
            Iterator<String> i = ctm.iterator();
            boolean more = true;
            while (more && i.hasNext()) {
                String ct = i.next();
                String suf = i.next();
                if (null == ct || !contentType.startsWith(ct.toLowerCase())) continue;
                more = false;
                if (null == suf || 0 == suf.length()) continue;
                suffix = suf;
            }
        }
        if ((maxSegLen = this.getMaxSegLength()) < 2) {
            maxSegLen = 2;
        }
        if ((maxPathLen = this.getMaxPathLength()) < 2) {
            maxPathLen = 2;
        }
        Map<String, String> characterMap = Collections.emptyMap();
        List<String> cm = this.getCharacterMap();
        if (null != cm && cm.size() > 1) {
            this.ensurePairs(cm);
            characterMap = new HashMap(cm.size());
            Iterator<String> i = cm.iterator();
            while (i.hasNext()) {
                String s1 = i.next();
                String s2 = i.next();
                if (null == s1 || 1 != s1.length() || null == s2 || 0 == s2.length()) continue;
                characterMap.put(s1, s2);
            }
        }
        if (".".equals(dotBegin = this.getDotBegin())) {
            dotBegin = null;
        }
        if (".".equals(dotEnd = this.getDotEnd())) {
            dotEnd = null;
        }
        if (null == (tld = this.getTooLongDirectory()) || 0 == tld.length() || -1 != tld.indexOf(File.separatorChar)) {
            tld = "LONG";
        }
        HashSet<String> underscoreSet = null;
        List<String> us = this.getUnderscoreSet();
        if (null != us && 0 != us.size()) {
            underscoreSet = new HashSet<String>(us.size(), 0.5f);
            for (String s : us) {
                if (null == s || 0 == s.length()) continue;
                underscoreSet.add(s.toLowerCase());
            }
        }
        return this.uriToFile(curi, host, port, uuri.getPath(), uuri.getQuery(), suffix, baseDir, maxSegLen, maxPathLen, this.getCaseSensitiveFilesystem(), this.getDirectoryFile(), characterMap, dotBegin, dotEnd, tld, this.getSuffixAtEnd(), underscoreSet);
    }

    private URIToFileReturn uriToFile(CrawlURI curi, String host, int port, String uriPath, String query, String suffix, String baseDir, int maxSegLen, int maxPathLen, boolean caseSensitive, String dirFile, Map<String, String> characterMap, String dotBegin, String dotEnd, String tooLongDir, boolean suffixAtEnd, Set<String> underscoreSet) throws IOException {
        assert (null == host || 0 != host.length());
        assert (0 != uriPath.length());
        assert ('/' == uriPath.charAt(0)) : "uriPath: " + uriPath;
        assert (-1 == uriPath.indexOf("//")) : "uriPath: " + uriPath;
        assert (-1 == uriPath.indexOf("/./")) : "uriPath: " + uriPath;
        assert (!uriPath.endsWith("/.")) : "uriPath: " + uriPath;
        assert (null == query || -1 == query.indexOf(47)) : "query: " + query;
        assert (null == suffix || 0 != suffix.length() && -1 == suffix.indexOf(47)) : "suffix: " + suffix;
        assert (0 != baseDir.length());
        assert (maxSegLen > 2) : "maxSegLen: " + maxSegLen;
        assert (maxPathLen > 1);
        assert (maxPathLen >= maxSegLen) : "maxSegLen: " + maxSegLen + " maxPathLen: " + maxPathLen;
        assert (0 != dirFile.length());
        assert (-1 == dirFile.indexOf("/")) : "dirFile: " + dirFile;
        assert (null != characterMap);
        assert (null == dotBegin || 0 != dotBegin.length());
        assert (null == dotEnd || !dotEnd.endsWith(".")) : "dotEnd: " + dotEnd;
        assert (0 != tooLongDir.length());
        assert ('/' != tooLongDir.charAt(0)) : "tooLongDir: " + tooLongDir;
        int nSegs = 0;
        for (int i = 0; uriPath.length() != i; ++i) {
            if ('/' != uriPath.charAt(i)) continue;
            ++nSegs;
        }
        assert (nSegs > 0) : "uriPath: " + uriPath;
        PathSegment[] segs = new PathSegment[nSegs];
        int slashIndex = 0;
        for (int i = 0; segs.length - 1 != i; ++i) {
            int nsi = uriPath.indexOf(47, slashIndex + 1);
            assert (nsi > slashIndex) : "uriPath: " + uriPath;
            segs[i] = new DirSegment(uriPath, slashIndex + 1, nsi, maxSegLen, caseSensitive, curi, characterMap, dotBegin, dotEnd, underscoreSet);
            slashIndex = nsi;
        }
        segs[segs.length - 1] = slashIndex < uriPath.length() - 1 ? new EndSegment(uriPath, slashIndex + 1, uriPath.length(), maxSegLen, caseSensitive, curi, characterMap, dotBegin, query, suffix, maxPathLen, suffixAtEnd) : new EndSegment(dirFile, 0, dirFile.length(), maxSegLen, caseSensitive, curi, characterMap, null, query, suffix, maxPathLen, suffixAtEnd);
        URIToFileReturn r = this.dirPath(baseDir, host, port, segs, maxPathLen - maxSegLen);
        if (null == r) {
            PathSegment endSegment = segs[segs.length - 1];
            segs = new PathSegment[]{new DirSegment(tooLongDir, 0, tooLongDir.length(), maxSegLen, caseSensitive, curi, EMPTY_MAP, null, null, null), endSegment};
            r = this.dirPath(baseDir, host, port, segs, maxPathLen - maxSegLen);
        }
        segs[segs.length - 1].addToPath(r);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToPath(RecordingInputStream recis, File dest) throws IOException {
        File tf = new File(dest.getPath() + "N");
        ReplayInputStream replayis = null;
        FileOutputStream fos = null;
        try {
            replayis = recis.getMessageBodyReplayInputStream();
            fos = new FileOutputStream(tf);
            replayis.readFullyTo((OutputStream)fos);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)replayis);
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)replayis);
        IOUtils.closeQuietly((OutputStream)fos);
        if (!tf.renameTo(dest)) {
            throw new IOException("Can not rename " + tf.getAbsolutePath() + " to " + dest.getAbsolutePath());
        }
    }

    class URIToFileReturn {
        private File filePath;
        private StringBuffer relativePath = new StringBuffer(255);

        URIToFileReturn(String baseDir, String host, int port) {
            StringBuffer startPath = new StringBuffer(baseDir.length() + 32);
            startPath.append(baseDir);
            if (baseDir.endsWith(File.separator)) {
                assert (1 != baseDir.length());
                startPath.deleteCharAt(startPath.length() - 1);
            }
            if (null != host) {
                startPath.append(File.separatorChar);
                startPath.append(host);
                this.relativePath.append(host);
            }
            if (port > 0) {
                startPath.append(File.separatorChar);
                startPath.append(port);
                this.relativePath.append(File.separatorChar);
                this.relativePath.append(port);
            }
            this.filePath = new File(startPath.toString());
        }

        void append(File f, String nextSegment) {
            this.filePath = f;
            if (0 != this.relativePath.length()) {
                this.relativePath.append(File.separatorChar);
            }
            this.relativePath.append(nextSegment);
        }

        File getFile() {
            return this.filePath;
        }

        String getRelativePath() {
            return this.relativePath.toString();
        }

        boolean longerThan(int maxLen) {
            return this.filePath.getPath().length() > maxLen;
        }

        void mkdirs() throws IOException {
            if (!this.filePath.exists()) {
                if (!this.filePath.mkdirs()) {
                    throw new IOException("Can not mkdir " + this.filePath.getAbsolutePath());
                }
            } else {
                if (!this.filePath.canWrite()) {
                    throw new IOException("Directory " + this.filePath.getAbsolutePath() + " not writeable.");
                }
                if (!this.filePath.isDirectory()) {
                    throw new IOException("File " + this.filePath.getAbsolutePath() + " is not a directory.");
                }
            }
        }
    }

    class LumpyString {
        private static final byte LUMP_BEGIN = 1;
        private static final byte LUMP_END = 2;
        private static final byte LUMP_MID = 4;
        private byte[] aux;
        private StringBuffer string;

        LumpyString(String str, int beginIndex, int endIndex, int padding, int maxLen, Map<String, String> characterMap, String dotBegin) {
            if (beginIndex < 0) {
                throw new IllegalArgumentException("beginIndex < 0: " + beginIndex);
            }
            if (endIndex < beginIndex) {
                throw new IllegalArgumentException("endIndex < beginIndex beginIndex: " + beginIndex + "endIndex: " + endIndex);
            }
            if (padding < 0) {
                throw new IllegalArgumentException("padding < 0: " + padding);
            }
            if (maxLen < 1) {
                throw new IllegalArgumentException("maxLen < 1: " + maxLen);
            }
            if (null == characterMap) {
                throw new IllegalArgumentException("characterMap null");
            }
            if (null != dotBegin && 0 == dotBegin.length()) {
                throw new IllegalArgumentException("dotBegin empty");
            }
            int cap = Math.min(2 * (endIndex - beginIndex) + padding + 1, maxLen);
            this.string = new StringBuffer(cap);
            this.aux = new byte[cap];
            for (int i = beginIndex; i != endIndex; ++i) {
                String s = str.substring(i, i + 1);
                String lump = ".".equals(s) && i == beginIndex && null != dotBegin ? dotBegin : characterMap.get(s);
                if (null == lump) {
                    if ("%".equals(s) && endIndex - i > 2 && -1 != Character.digit(str.charAt(i + 1), 16) && -1 != Character.digit(str.charAt(i + 2), 16)) {
                        lump = str.substring(i, i + 3);
                        i += 2;
                    } else {
                        lump = s;
                    }
                }
                if (this.string.length() + lump.length() > maxLen) {
                    assert (this.checkInvariants());
                    return;
                }
                this.append(lump);
            }
            assert (this.checkInvariants());
        }

        public String toString() {
            assert (this.checkInvariants());
            return this.string.toString();
        }

        void append(String lump) {
            if (null == lump) {
                throw new IllegalArgumentException("lump null");
            }
            int lumpLen = lump.length();
            if (0 == lumpLen) {
                throw new IllegalArgumentException("lump empty");
            }
            int pos = this.string.length();
            this.ensureCapacity(pos + lumpLen);
            if (1 == lumpLen) {
                this.aux[pos] = 3;
            } else {
                assert (lumpLen > 1);
                this.aux[pos] = 1;
                ++pos;
                for (int i = lumpLen - 2; 0 != i; --i) {
                    this.aux[pos] = 4;
                    ++pos;
                }
                this.aux[pos] = 2;
            }
            this.string.append(lump);
            assert (this.checkInvariants());
        }

        StringBuffer asStringBuffer() {
            return this.string;
        }

        boolean endsWith(char ch) {
            assert (this.checkInvariants());
            int len = this.string.length();
            return 0 != len && this.string.charAt(len - 1) == ch;
        }

        void prepend(char ch) {
            assert (this.checkInvariants());
            int oldLen = this.string.length();
            this.ensureCapacity(1 + oldLen);
            this.string.insert(0, ch);
            System.arraycopy(this.aux, 0, this.aux, 1, oldLen);
            this.aux[0] = 3;
            assert (this.checkInvariants());
        }

        int length() {
            assert (this.checkInvariants());
            return this.string.length();
        }

        void trimToMax(int maxLen) {
            if (maxLen < 0) {
                throw new IllegalArgumentException("maxLen < 0: " + maxLen);
            }
            assert (this.checkInvariants());
            int cl = this.string.length();
            if (cl > maxLen) {
                int nl;
                for (nl = maxLen; 0 != nl && 2 != (this.aux[nl - 1] & 2); --nl) {
                }
                for (int i = nl; i != cl; ++i) {
                    this.aux[i] = 0;
                }
                this.string.setLength(nl);
            }
            assert (this.checkInvariants());
        }

        private boolean checkInvariants() {
            assert (this.aux.length >= this.string.length()) : "aux.length: " + this.aux.length + " string.length(): " + this.string.length();
            assert (0 == this.string.length() || 1 == (this.aux[0] & 1)) : "aux[0]: " + this.aux[0];
            assert (0 == this.string.length() || 2 == (this.aux[this.string.length() - 1] & 2)) : "aux[end]: " + this.aux[this.string.length() - 1];
            return true;
        }

        private void ensureCapacity(int minCapacity) {
            assert (this.checkInvariants());
            if (minCapacity > this.aux.length) {
                int nc;
                for (nc = 2 * this.aux.length; nc < minCapacity; nc *= 2) {
                }
                byte[] oldAux = this.aux;
                this.aux = new byte[nc];
                System.arraycopy(oldAux, 0, this.aux, 0, this.string.length());
            }
            this.string.ensureCapacity(minCapacity);
            assert (this.checkInvariants());
        }
    }

    class EndSegment
    extends PathSegment {
        private int dirPathLen;
        private int maxPathLen;
        private LumpyString query;
        private String suffix;
        private boolean suffixAtEnd;
        private String uniquePart;

        EndSegment(String uriPath, int beginIndex, int endIndex, int maxSegLen, boolean caseSensitive, CrawlURI curi, Map<String, String> characterMap, String dotBegin, String query, String suffix, int maxPathLen, boolean suffixAtEnd) {
            super(maxSegLen - 1, caseSensitive, curi);
            this.query = null;
            this.suffix = null;
            this.uniquePart = null;
            int mpe = endIndex;
            int ldi = uriPath.lastIndexOf(46);
            if (ldi > 0 && ldi < endIndex - 1 && ldi > beginIndex) {
                mpe = ldi;
            }
            this.suffix = suffix;
            if (null == this.suffix && mpe < endIndex - 1) {
                LumpyString ls = new LumpyString(uriPath, mpe + 1, endIndex, 0, this.maxSegLen, characterMap, null);
                this.suffix = ls.toString();
            }
            int pad = (null == this.suffix ? 0 : 1 + this.suffix.length()) + (null == query ? 0 : query.length());
            this.mainPart = new LumpyString(uriPath, beginIndex, mpe, pad, this.maxSegLen, characterMap, dotBegin);
            this.maxPathLen = maxPathLen - 1;
            if (null != query) {
                this.query = new LumpyString(query, 0, query.length(), 0, this.maxSegLen, characterMap, null);
            }
            this.suffixAtEnd = suffixAtEnd;
        }

        @Override
        void addToPath(URIToFileReturn currentPath) {
            File fsf = currentPath.getFile();
            NumberFormat nf = null;
            this.dirPathLen = 1 + fsf.getPath().length();
            int i = 0;
            while (true) {
                if (0 != i) {
                    if (null == nf) {
                        nf = NumberFormat.getIntegerInstance();
                    }
                    this.uniquePart = nf.format(i);
                }
                this.trimWithPadding(null == this.uniquePart ? 0 : this.uniquePart.length());
                String segStr = this.joinParts();
                File f = new File(fsf, segStr);
                int er = this.existsMaybeCaseSensitive(fsf, segStr, f);
                switch (er) {
                    case 1: {
                        currentPath.append(f, segStr);
                        return;
                    }
                    case 2: {
                        if (!f.isFile()) break;
                        currentPath.append(f, segStr);
                        return;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Code: " + er);
                    }
                }
                ++i;
            }
        }

        private String joinParts() {
            StringBuffer sb = new StringBuffer(this.length());
            sb.append(this.mainPart.asStringBuffer());
            if (null != this.uniquePart) {
                sb.append(this.uniquePart);
            }
            if (this.suffixAtEnd) {
                if (null != this.query) {
                    sb.append(this.query);
                }
                if (null != this.suffix) {
                    sb.append('.');
                    sb.append(this.suffix);
                }
            } else {
                if (null != this.suffix) {
                    sb.append('.');
                    sb.append(this.suffix);
                }
                if (null != this.query) {
                    sb.append(this.query);
                }
            }
            return sb.toString();
        }

        private int lenAvail() {
            int len = this.length();
            return Math.min(this.maxSegLen - len, this.maxPathLen - this.dirPathLen - len);
        }

        private int length() {
            int r = this.mainPart.length();
            if (null != this.uniquePart) {
                r += this.uniquePart.length();
            }
            if (null != this.query) {
                r += this.query.length();
            }
            if (null != this.suffix) {
                r += 1 + this.suffix.length();
            }
            return r;
        }

        private void trimWithPadding(int padding) {
            assert (padding >= 0) : "padding: " + padding;
            int la = this.lenAvail();
            if (la >= padding) {
                return;
            }
            if (null != this.query) {
                this.query.trimToMax(Math.max(0, this.query.length() - (padding - la)));
                if (0 == this.query.length()) {
                    this.query = null;
                }
                if ((la = this.lenAvail()) >= padding) {
                    return;
                }
            }
            this.mainPart.trimToMax(Math.max(1, this.mainPart.length() - (padding - la)));
            la = this.lenAvail();
            if (la >= padding) {
                return;
            }
            if (null != this.suffix) {
                this.suffix = this.suffix.substring(0, Math.max(1, this.suffix.length() - (padding - la)));
                la = this.lenAvail();
                if (la >= padding) {
                    return;
                }
            }
            throw new IllegalStateException("Can not trim " + this.curi.toString());
        }
    }

    class DirSegment
    extends PathSegment {
        private Set<String> underscoreSet;

        DirSegment(String uriPath, int beginIndex, int endIndex, int maxSegLen, boolean caseSensitive, CrawlURI curi, Map<String, String> characterMap, String dotBegin, String dotEnd, Set<String> underscoreSet) {
            super(maxSegLen, caseSensitive, curi);
            this.mainPart = new LumpyString(uriPath, beginIndex, endIndex, null == dotEnd ? 0 : dotEnd.length(), this.maxSegLen, characterMap, dotBegin);
            if (null != dotEnd) {
                int dl = dotEnd.length();
                while (this.mainPart.endsWith('.')) {
                    this.mainPart.trimToMax(this.mainPart.length() - 1);
                    if (this.mainPart.length() + dl > this.maxSegLen) continue;
                    this.mainPart.append(dotEnd);
                }
            }
            this.underscoreSet = underscoreSet;
        }

        @Override
        void addToPath(URIToFileReturn currentPath) throws IOException {
            NumberFormat nf = null;
            int startLen = this.mainPart.length();
            int i = 0;
            while (true) {
                if (0 != i) {
                    if (null == nf) {
                        nf = NumberFormat.getIntegerInstance();
                    }
                    String ending = nf.format(i);
                    this.mainPart.trimToMax(Math.min(startLen, this.maxSegLen - ending.length()));
                    this.mainPart.append(ending);
                }
                String segStr = this.mainPart.toString();
                if (null != this.underscoreSet && this.underscoreSet.contains(segStr.toLowerCase())) {
                    this.mainPart.prepend('_');
                    ++startLen;
                    this.mainPart.trimToMax(this.maxSegLen);
                    segStr = this.mainPart.toString();
                }
                File fsf = currentPath.getFile();
                File f = new File(fsf, segStr);
                int er = this.existsMaybeCaseSensitive(fsf, segStr, f);
                switch (er) {
                    case 1: {
                        if (!f.mkdir()) {
                            throw new IOException("Can not mkdir " + f.getAbsolutePath());
                        }
                        currentPath.append(f, segStr);
                        return;
                    }
                    case 2: {
                        if (!f.isDirectory()) break;
                        if (!f.canWrite()) {
                            throw new IOException("Directory " + f.getAbsolutePath() + " not writeable.");
                        }
                        currentPath.append(f, segStr);
                        return;
                    }
                    case 3: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Code: " + er);
                    }
                }
                ++i;
            }
        }
    }

    abstract class PathSegment {
        protected static final int EXISTS_NOT = 1;
        protected static final int EXISTS_EXACT_MATCH = 2;
        protected static final int EXISTS_CASE_INSENSITIVE_MATCH = 3;
        protected CrawlURI curi;
        protected LumpyString mainPart = null;
        protected int maxSegLen;
        private boolean caseSensitive;

        PathSegment(int maxSegLen, boolean caseSensitive, CrawlURI curi) {
            if (maxSegLen < 2) {
                throw new IllegalArgumentException("maxSegLen: " + maxSegLen);
            }
            this.maxSegLen = maxSegLen;
            this.caseSensitive = caseSensitive;
            this.curi = curi;
        }

        abstract void addToPath(URIToFileReturn var1) throws IOException;

        protected int existsMaybeCaseSensitive(File fsf, String segStr, File check) {
            if (this.caseSensitive) {
                return check.exists() ? 2 : 1;
            }
            if (!check.exists()) {
                return 1;
            }
            String[] fna = fsf.list(new CaseInsensitiveFilenameFilter(segStr));
            for (int i = 0; fna.length != i; ++i) {
                if (!segStr.equals(fna[i])) continue;
                return 2;
            }
            return 3;
        }

        class CaseInsensitiveFilenameFilter
        implements FilenameFilter {
            private String target;

            CaseInsensitiveFilenameFilter(String target) {
                if (null == target) {
                    throw new IllegalArgumentException("target null");
                }
                if (0 == target.length()) {
                    throw new IllegalArgumentException("target empty");
                }
                this.target = target;
            }

            @Override
            public boolean accept(File dir, String name) {
                return this.target.equalsIgnoreCase(name);
            }
        }
    }
}

