/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.writer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.archive.io.WriterPoolMember;
import org.archive.io.warc.WARCRecordInfo;
import org.archive.io.warc.WARCWriter;
import org.archive.modules.CrawlURI;
import org.archive.modules.ProcessResult;
import org.archive.modules.deciderules.recrawl.IdenticalDigestDecideRule;
import org.archive.modules.warc.DnsResponseRecordBuilder;
import org.archive.modules.warc.FtpControlConversationRecordBuilder;
import org.archive.modules.warc.FtpResponseRecordBuilder;
import org.archive.modules.warc.HttpRequestRecordBuilder;
import org.archive.modules.warc.HttpResponseRecordBuilder;
import org.archive.modules.warc.MetadataRecordBuilder;
import org.archive.modules.warc.RevisitRecordBuilder;
import org.archive.modules.warc.WARCRecordBuilder;
import org.archive.modules.warc.WhoisResponseRecordBuilder;
import org.archive.modules.writer.BaseWARCWriterProcessor;
import org.archive.spring.HasKeyedProperties;
import org.json.JSONException;
import org.json.JSONObject;

public class WARCWriterChainProcessor
extends BaseWARCWriterProcessor
implements HasKeyedProperties {
    private static final Logger logger = Logger.getLogger(WARCWriterChainProcessor.class.getName());

    public WARCWriterChainProcessor() {
        this.setChain(Arrays.asList(new DnsResponseRecordBuilder(), new HttpResponseRecordBuilder(), new WhoisResponseRecordBuilder(), new FtpControlConversationRecordBuilder(), new FtpResponseRecordBuilder(), new RevisitRecordBuilder(), new HttpRequestRecordBuilder(), new MetadataRecordBuilder()));
    }

    public List<? extends WARCRecordBuilder> getChain() {
        return (List)this.kp.get("chain");
    }

    public void setChain(List<? extends WARCRecordBuilder> chain) {
        this.kp.put((Object)"chain", chain);
    }

    @Override
    protected boolean shouldWrite(CrawlURI curi) {
        if (this.getSkipIdenticalDigests() && IdenticalDigestDecideRule.hasIdenticalDigest(curi)) {
            curi.getAnnotations().add("unwritten:identicalDigest");
            return false;
        }
        if (curi.getFetchStatus() <= 0) {
            curi.getAnnotations().add("unwritten:status");
            return false;
        }
        return true;
    }

    @Override
    protected ProcessResult innerProcessResult(CrawlURI curi) {
        try {
            if (this.shouldWrite(curi)) {
                return this.write(curi);
            }
            this.copyForwardWriteTagIfDupe(curi);
        }
        catch (IOException e) {
            curi.getNonFatalFailures().add(e);
            logger.log(Level.SEVERE, "Failed write of Records: " + curi.toString(), e);
        }
        return ProcessResult.PROCEED;
    }

    protected ProcessResult write(CrawlURI curi) throws IOException {
        WARCWriter writer = (WARCWriter)this.getPool().borrowFile();
        writer.resetTmpStats();
        writer.resetTmpRecordLog();
        long position = writer.getPosition();
        try {
            writer.checkSize();
            if (writer.getPosition() != position) {
                this.addTotalBytesWritten(writer.getPosition() - position);
                this.addStats(writer.getTmpStats());
                writer.resetTmpStats();
                writer.resetTmpRecordLog();
                position = writer.getPosition();
            }
            this.writeRecords(curi, writer);
        }
        catch (IOException e) {
            this.getPool().invalidateFile((WriterPoolMember)writer);
            writer = null;
            throw e;
        }
        finally {
            if (writer != null) {
                this.updateMetadataAfterWrite(curi, writer, position);
                this.getPool().returnFile((WriterPoolMember)writer);
            }
        }
        return this.checkBytesWritten();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRecords(CrawlURI curi, WARCWriter writer) throws IOException {
        URI concurrentTo = null;
        for (WARCRecordBuilder wARCRecordBuilder : this.getChain()) {
            WARCRecordInfo record;
            if (!wARCRecordBuilder.shouldBuildRecord(curi) || (record = wARCRecordBuilder.buildRecord(curi, concurrentTo)) == null) continue;
            record.setWARCFileOffset(Long.valueOf(writer.getPosition()));
            writer.writeRecord(record);
            record.setWARCFilename(writer.getFilenameWithoutOccupiedSuffix());
            InputStream is = null;
            try {
                is = record.getContentStream();
                is.close();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "problem closing Warc Record Content Stream " + e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)record.getContentStream());
            }
            if (concurrentTo == null) {
                concurrentTo = record.getRecordId();
            }
            wARCRecordBuilder.postWrite(record, curi);
        }
    }

    @Override
    protected JSONObject toCheckpointJson() throws JSONException {
        JSONObject json = super.toCheckpointJson();
        json.put("urlsWritten", (Object)this.urlsWritten);
        json.put("stats", (Map)this.stats);
        return json;
    }

    @Override
    protected void fromCheckpointJson(JSONObject json) throws JSONException {
        super.fromCheckpointJson(json);
        if (json.has("urlsWritten")) {
            this.urlsWritten.set(json.getLong("urlsWritten"));
        }
        if (json.has("stats")) {
            HashMap<String, Map<String, Long>> cpStats = new HashMap<String, Map<String, Long>>();
            JSONObject jsonStats = json.getJSONObject("stats");
            if (JSONObject.getNames((JSONObject)jsonStats) != null) {
                for (String key1 : JSONObject.getNames((JSONObject)jsonStats)) {
                    JSONObject jsonSubstats = jsonStats.getJSONObject(key1);
                    if (!cpStats.containsKey(key1)) {
                        cpStats.put(key1, new HashMap());
                    }
                    Map<String, Long> substats = cpStats.get(key1);
                    for (String key2 : JSONObject.getNames((JSONObject)jsonSubstats)) {
                        long value = jsonSubstats.getLong(key2);
                        substats.put(key2, value);
                    }
                }
                this.addStats(cpStats);
            }
        }
    }
}

