/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.writer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.archive.format.warc.WARCConstants;
import org.archive.io.ReplayInputStream;
import org.archive.io.WriterPoolMember;
import org.archive.io.warc.WARCRecordInfo;
import org.archive.io.warc.WARCWriter;
import org.archive.io.warc.WARCWriterPoolSettings;
import org.archive.modules.CrawlURI;
import org.archive.modules.ProcessResult;
import org.archive.modules.revisit.RevisitProfile;
import org.archive.modules.writer.BaseWARCWriterProcessor;
import org.archive.util.ArchiveUtils;
import org.archive.util.anvl.ANVLRecord;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public class WARCWriterProcessor
extends BaseWARCWriterProcessor
implements WARCWriterPoolSettings {
    private static final long serialVersionUID = 6182850087635847443L;
    private static final Logger logger = Logger.getLogger(WARCWriterProcessor.class.getName());

    public boolean getWriteRequests() {
        return (Boolean)this.kp.get("writeRequests");
    }

    public void setWriteRequests(boolean writeRequests) {
        this.kp.put((Object)"writeRequests", (Object)writeRequests);
    }

    public boolean getWriteMetadata() {
        return (Boolean)this.kp.get("writeMetadata");
    }

    public void setWriteMetadata(boolean writeMetadata) {
        this.kp.put((Object)"writeMetadata", (Object)writeMetadata);
    }

    @Deprecated
    public void setWriteRevisitForIdenticalDigests(boolean writeRevisits) {
        logger.warning("setting writeRevisitForIdenticalDigests is deprecated, value ignored");
    }

    @Deprecated
    public void setWriteRevisitForNotModified(boolean writeRevisits) {
        logger.warning("setting writeRevisitForNotModified is deprecated, value ignored");
    }

    public WARCWriterProcessor() {
        this.setWriteRequests(true);
        this.setWriteMetadata(true);
    }

    @Override
    protected ProcessResult innerProcessResult(CrawlURI curi) {
        String scheme = curi.getUURI().getScheme().toLowerCase();
        try {
            if (this.shouldWrite(curi)) {
                return this.write(scheme, curi);
            }
            this.copyForwardWriteTagIfDupe(curi);
        }
        catch (IOException e) {
            curi.getNonFatalFailures().add(e);
            logger.log(Level.SEVERE, "Failed write of Records: " + curi.toString(), e);
        }
        return ProcessResult.PROCEED;
    }

    protected ProcessResult write(String lowerCaseScheme, CrawlURI curi) throws IOException {
        WARCWriter writer = (WARCWriter)this.getPool().borrowFile();
        writer.resetTmpStats();
        writer.resetTmpRecordLog();
        long position = writer.getPosition();
        try {
            writer.checkSize();
            if (writer.getPosition() != position) {
                this.addTotalBytesWritten(writer.getPosition() - position);
                this.addStats(writer.getTmpStats());
                writer.resetTmpStats();
                writer.resetTmpRecordLog();
                position = writer.getPosition();
            }
            URI baseid = this.getRecordID();
            String timestamp = ArchiveUtils.getLog14Date((long)curi.getFetchBeginTime());
            if (lowerCaseScheme.startsWith("http")) {
                this.writeHttpRecords(curi, writer, baseid, timestamp);
            } else if (lowerCaseScheme.equals("dns")) {
                this.writeDnsRecords(curi, writer, baseid, timestamp);
            } else if (lowerCaseScheme.equals("ftp") || lowerCaseScheme.equals("sftp")) {
                this.writeFtpRecords(writer, curi, baseid, timestamp);
            } else if (lowerCaseScheme.equals("whois")) {
                this.writeWhoisRecords(writer, curi, baseid, timestamp);
            } else {
                logger.warning("No handler for scheme " + lowerCaseScheme);
            }
        }
        catch (IOException e) {
            this.getPool().invalidateFile((WriterPoolMember)writer);
            writer = null;
            throw e;
        }
        finally {
            if (writer != null) {
                this.updateMetadataAfterWrite(curi, writer, position);
                this.getPool().returnFile((WriterPoolMember)writer);
            }
        }
        return this.checkBytesWritten();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeDnsRecords(CrawlURI curi, WARCWriter w, URI baseid, String timestamp) throws IOException {
        WARCRecordInfo recordInfo = new WARCRecordInfo();
        recordInfo.setType(WARCConstants.WARCRecordType.response);
        recordInfo.setUrl(curi.toString());
        recordInfo.setCreate14DigitDate(timestamp);
        recordInfo.setMimetype(curi.getContentType());
        recordInfo.setRecordId(baseid);
        recordInfo.setContentLength(curi.getRecorder().getRecordedInput().getSize());
        recordInfo.setEnforceLength(true);
        if (curi.getServerIP() != null) {
            recordInfo.addExtraHeader("WARC-IP-Address", curi.getServerIP());
        }
        ReplayInputStream ris = curi.getRecorder().getRecordedInput().getReplayInputStream();
        recordInfo.setContentStream((InputStream)ris);
        try {
            w.writeRecord(recordInfo);
        }
        finally {
            IOUtils.closeQuietly((InputStream)ris);
        }
        recordInfo.getRecordId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeWhoisRecords(WARCWriter w, CrawlURI curi, URI baseid, String timestamp) throws IOException {
        WARCRecordInfo recordInfo = new WARCRecordInfo();
        recordInfo.setType(WARCConstants.WARCRecordType.response);
        recordInfo.setUrl(curi.toString());
        recordInfo.setCreate14DigitDate(timestamp);
        recordInfo.setMimetype(curi.getContentType());
        recordInfo.setRecordId(baseid);
        recordInfo.setContentLength(curi.getRecorder().getRecordedInput().getSize());
        recordInfo.setEnforceLength(true);
        if (curi.getServerIP() != null) {
            recordInfo.addExtraHeader("WARC-IP-Address", curi.getServerIP());
        }
        ReplayInputStream ris = curi.getRecorder().getRecordedInput().getReplayInputStream();
        recordInfo.setContentStream((InputStream)ris);
        try {
            w.writeRecord(recordInfo);
        }
        finally {
            IOUtils.closeQuietly((InputStream)ris);
        }
        recordInfo.getRecordId();
    }

    protected void writeHttpRecords(CrawlURI curi, WARCWriter w, URI baseid, String timestamp) throws IOException {
        URI rid;
        ANVLRecord headers = new ANVLRecord();
        headers.addLabelValue("WARC-IP-Address", this.getHostAddress(curi));
        if (curi.isRevisit()) {
            rid = this.writeRevisit(w, timestamp, "application/http; msgtype=response", baseid, curi, headers);
        } else {
            if (curi.getContentDigest() != null) {
                headers.addLabelValue("WARC-Payload-Digest", curi.getContentDigestSchemeString());
            }
            String value = null;
            Collection<String> anno = curi.getAnnotations();
            if (anno.contains("timeTrunc")) {
                value = "time";
            } else if (anno.contains("lenTrunc")) {
                value = "length";
            } else if (anno.contains("headerTrunc")) {
                value = "long-headers";
            }
            if (value != null) {
                headers.addLabelValue("WARC-Truncated", value);
            }
            rid = this.writeResponse(w, timestamp, "application/http; msgtype=response", baseid, curi, headers);
        }
        headers = new ANVLRecord();
        headers.addLabelValue("WARC-Concurrent-To", '<' + rid.toString() + '>');
        if (this.getWriteRequests()) {
            this.writeRequest(w, timestamp, "application/http; msgtype=request", baseid, curi, headers);
        }
        if (this.getWriteMetadata()) {
            this.writeMetadata(w, timestamp, baseid, curi, headers);
        }
    }

    protected void writeFtpRecords(WARCWriter w, CrawlURI curi, URI baseid, String timestamp) throws IOException {
        ANVLRecord headers = new ANVLRecord();
        headers.addLabelValue("WARC-IP-Address", this.getHostAddress(curi));
        String controlConversation = curi.getData().get("ftp-control-conversation").toString();
        URI rid = this.writeFtpControlConversation(w, timestamp, baseid, curi, headers, controlConversation);
        if (curi.getContentDigest() != null) {
            headers.addLabelValue("WARC-Payload-Digest", curi.getContentDigestSchemeString());
        }
        if (curi.getRecorder() != null) {
            if (curi.isRevisit()) {
                rid = this.writeRevisit(w, timestamp, null, baseid, curi, headers, 0L);
            } else {
                headers = new ANVLRecord();
                String value = null;
                Collection<String> anno = curi.getAnnotations();
                if (anno.contains("timeTrunc")) {
                    value = "time";
                } else if (anno.contains("lenTrunc")) {
                    value = "length";
                } else if (anno.contains("headerTrunc")) {
                    value = "long-headers";
                }
                if (value != null) {
                    headers.addLabelValue("WARC-Truncated", value);
                }
                if (curi.getContentDigest() != null) {
                    headers.addLabelValue("WARC-Payload-Digest", curi.getContentDigestSchemeString());
                }
                headers.addLabelValue("WARC-Concurrent-To", '<' + rid.toString() + '>');
                rid = this.writeResource(w, timestamp, curi.getContentType(), baseid, curi, headers);
            }
        }
        if (this.getWriteMetadata()) {
            headers = new ANVLRecord();
            headers.addLabelValue("WARC-Concurrent-To", '<' + rid.toString() + '>');
            this.writeMetadata(w, timestamp, baseid, curi, headers);
        }
    }

    protected URI writeFtpControlConversation(WARCWriter w, String timestamp, URI baseid, CrawlURI curi, ANVLRecord headers, String controlConversation) throws IOException {
        WARCRecordInfo recordInfo = new WARCRecordInfo();
        recordInfo.setCreate14DigitDate(timestamp);
        recordInfo.setUrl(curi.toString());
        recordInfo.setMimetype("text/x-ftp-control-conversation");
        recordInfo.setExtraHeaders(headers);
        recordInfo.setEnforceLength(true);
        recordInfo.setType(WARCConstants.WARCRecordType.metadata);
        recordInfo.setRecordId(this.qualifyRecordID(baseid, "type", WARCConstants.WARCRecordType.metadata.toString()));
        byte[] b = controlConversation.getBytes("UTF-8");
        recordInfo.setContentStream((InputStream)new ByteArrayInputStream(b));
        recordInfo.setContentLength((long)b.length);
        w.writeRecord(recordInfo);
        return recordInfo.getRecordId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URI writeRequest(WARCWriter w, String timestamp, String mimetype, URI baseid, CrawlURI curi, ANVLRecord namedFields) throws IOException {
        WARCRecordInfo recordInfo = new WARCRecordInfo();
        recordInfo.setType(WARCConstants.WARCRecordType.request);
        recordInfo.setUrl(curi.toString());
        recordInfo.setCreate14DigitDate(timestamp);
        recordInfo.setMimetype(mimetype);
        recordInfo.setExtraHeaders(namedFields);
        recordInfo.setContentLength(curi.getRecorder().getRecordedOutput().getSize());
        recordInfo.setEnforceLength(true);
        URI uid = this.qualifyRecordID(baseid, "type", WARCConstants.WARCRecordType.request.toString());
        recordInfo.setRecordId(uid);
        ReplayInputStream ris = curi.getRecorder().getRecordedOutput().getReplayInputStream();
        recordInfo.setContentStream((InputStream)ris);
        try {
            w.writeRecord(recordInfo);
        }
        finally {
            IOUtils.closeQuietly((InputStream)ris);
        }
        return recordInfo.getRecordId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URI writeResponse(WARCWriter w, String timestamp, String mimetype, URI baseid, CrawlURI curi, ANVLRecord suppliedFields) throws IOException {
        ANVLRecord namedFields = suppliedFields;
        if (curi.getData().containsKey("warc-response-headers")) {
            namedFields = namedFields.clone();
            for (Object headerObj : curi.getDataList("warc-response-headers")) {
                String[] kv = StringUtils.split((String)((String)headerObj), (String)":", (int)2);
                namedFields.addLabelValue(kv[0].trim(), kv[1].trim());
            }
        }
        WARCRecordInfo recordInfo = new WARCRecordInfo();
        recordInfo.setType(WARCConstants.WARCRecordType.response);
        recordInfo.setUrl(curi.toString());
        recordInfo.setCreate14DigitDate(timestamp);
        recordInfo.setMimetype(mimetype);
        recordInfo.setRecordId(baseid);
        recordInfo.setExtraHeaders(namedFields);
        recordInfo.setContentLength(curi.getRecorder().getRecordedInput().getSize());
        recordInfo.setEnforceLength(true);
        ReplayInputStream ris = curi.getRecorder().getRecordedInput().getReplayInputStream();
        recordInfo.setContentStream((InputStream)ris);
        try {
            w.writeRecord(recordInfo);
        }
        finally {
            IOUtils.closeQuietly((InputStream)ris);
        }
        return recordInfo.getRecordId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URI writeResource(WARCWriter w, String timestamp, String mimetype, URI baseid, CrawlURI curi, ANVLRecord namedFields) throws IOException {
        WARCRecordInfo recordInfo = new WARCRecordInfo();
        recordInfo.setType(WARCConstants.WARCRecordType.resource);
        recordInfo.setUrl(curi.toString());
        recordInfo.setCreate14DigitDate(timestamp);
        recordInfo.setMimetype(mimetype);
        recordInfo.setRecordId(baseid);
        recordInfo.setExtraHeaders(namedFields);
        recordInfo.setContentLength(curi.getRecorder().getRecordedInput().getSize());
        recordInfo.setEnforceLength(true);
        ReplayInputStream ris = curi.getRecorder().getRecordedInput().getReplayInputStream();
        recordInfo.setContentStream((InputStream)ris);
        try {
            w.writeRecord(recordInfo);
        }
        finally {
            IOUtils.closeQuietly((InputStream)ris);
        }
        return recordInfo.getRecordId();
    }

    protected URI writeRevisit(WARCWriter w, String timestamp, String mimetype, URI baseid, CrawlURI curi, ANVLRecord headers) throws IOException {
        long revisedLength = 0L;
        if (curi.getRevisitProfile().getProfileName().equals("http://netpreserve.org/warc/1.0/revisit/identical-payload-digest")) {
            revisedLength = curi.getRecorder().getRecordedInput().getContentBegin();
            revisedLength = revisedLength > 0L ? revisedLength : curi.getRecorder().getRecordedInput().getSize();
        }
        return this.writeRevisit(w, timestamp, mimetype, baseid, curi, headers, revisedLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URI writeRevisit(WARCWriter w, String timestamp, String mimetype, URI baseid, CrawlURI curi, ANVLRecord headers, long contentLength) throws IOException {
        WARCRecordInfo recordInfo = new WARCRecordInfo();
        recordInfo.setType(WARCConstants.WARCRecordType.revisit);
        recordInfo.setUrl(curi.toString());
        recordInfo.setCreate14DigitDate(timestamp);
        recordInfo.setMimetype(mimetype);
        recordInfo.setRecordId(baseid);
        recordInfo.setContentLength(contentLength);
        recordInfo.setEnforceLength(false);
        RevisitProfile revisitProfile = curi.getRevisitProfile();
        headers.addLabelValue("WARC-Profile", revisitProfile.getProfileName());
        headers.addLabelValue("WARC-Truncated", "length");
        Map<String, String> revisitHeaders = revisitProfile.getWarcHeaders();
        if (!revisitHeaders.isEmpty()) {
            recordInfo.setExtraHeaders(headers);
            for (String key : revisitHeaders.keySet()) {
                headers.addLabelValue(key, revisitHeaders.get(key));
            }
        }
        ReplayInputStream ris = curi.getRecorder().getRecordedInput().getReplayInputStream();
        recordInfo.setContentStream((InputStream)ris);
        try {
            w.writeRecord(recordInfo);
        }
        finally {
            IOUtils.closeQuietly((InputStream)ris);
        }
        return recordInfo.getRecordId();
    }

    protected void saveHeader(CrawlURI curi, ANVLRecord warcHeaders, String origName, String newName) {
        String value = curi.getHttpResponseHeader(origName);
        if (value != null) {
            warcHeaders.addLabelValue(newName, value);
        }
    }

    protected URI writeMetadata(WARCWriter w, String timestamp, URI baseid, CrawlURI curi, ANVLRecord namedFields) throws IOException {
        WARCRecordInfo recordInfo = new WARCRecordInfo();
        recordInfo.setType(WARCConstants.WARCRecordType.metadata);
        recordInfo.setUrl(curi.toString());
        recordInfo.setCreate14DigitDate(timestamp);
        recordInfo.setMimetype("application/warc-fields");
        recordInfo.setExtraHeaders(namedFields);
        recordInfo.setEnforceLength(true);
        recordInfo.setRecordId(this.qualifyRecordID(baseid, "type", WARCConstants.WARCRecordType.metadata.toString()));
        ANVLRecord r = new ANVLRecord();
        if (curi.isSeed()) {
            r.addLabel("seed");
        } else {
            if (curi.forceFetch()) {
                r.addLabel("force-fetch");
            }
            if (StringUtils.isNotBlank((String)WARCWriterProcessor.flattenVia(curi))) {
                r.addLabelValue("via", WARCWriterProcessor.flattenVia(curi));
            }
            if (StringUtils.isNotBlank((String)curi.getPathFromSeed())) {
                r.addLabelValue("hopsFromSeed", curi.getPathFromSeed());
            }
            if (curi.containsDataKey("source")) {
                r.addLabelValue("sourceTag", (String)curi.getData().get("source"));
            }
        }
        long duration = curi.getFetchCompletedTime() - curi.getFetchBeginTime();
        if (duration > -1L) {
            r.addLabelValue("fetchTimeMs", Long.toString(duration));
        }
        if (curi.getData().containsKey("ftp-fetch-status")) {
            r.addLabelValue("ftpFetchStatus", curi.getData().get("ftp-fetch-status").toString());
        }
        if (curi.getRecorder() != null && curi.getRecorder().getCharset() != null) {
            r.addLabelValue("charsetForLinkExtraction", curi.getRecorder().getCharset().name());
        }
        for (String string : curi.getAnnotations()) {
            if (!string.startsWith("usingCharsetIn") && !string.startsWith("inconsistentCharsetIn")) continue;
            String[] kv = string.split(":", 2);
            r.addLabelValue(kv[0], kv[1]);
        }
        Collection<CrawlURI> links = curi.getOutLinks();
        if (links != null && links.size() > 0) {
            for (CrawlURI link : links) {
                r.addLabelValue("outlink", link.getURI() + " " + link.getLastHop() + " " + link.getViaContext());
            }
        }
        byte[] byArray = r.getUTF8Bytes();
        recordInfo.setContentStream((InputStream)new ByteArrayInputStream(byArray));
        recordInfo.setContentLength((long)byArray.length);
        w.writeRecord(recordInfo);
        return recordInfo.getRecordId();
    }

    protected URI qualifyRecordID(URI base, String key, String value) throws IOException {
        HashMap<String, String> qualifiers = new HashMap<String, String>(1);
        qualifiers.put(key, value);
        return this.generator.qualifyRecordID(base, qualifiers);
    }

    @Override
    protected JSONObject toCheckpointJson() throws JSONException {
        JSONObject json = super.toCheckpointJson();
        json.put("urlsWritten", (Object)this.urlsWritten);
        json.put("totalBytesWritten", this.getTotalBytesWritten());
        json.put("stats", (Map)this.stats);
        return json;
    }

    @Override
    protected void fromCheckpointJson(JSONObject json) throws JSONException {
        super.fromCheckpointJson(json);
        if (json.has("urlsWritten")) {
            this.urlsWritten.set(json.getLong("urlsWritten"));
        }
        if (json.has("totalBytesWritten")) {
            this.setTotalBytesWritten(json.getLong("totalBytesWritten"));
        }
        if (json.has("stats")) {
            HashMap<String, Map<String, Long>> cpStats = new HashMap<String, Map<String, Long>>();
            JSONObject jsonStats = json.getJSONObject("stats");
            if (JSONObject.getNames((JSONObject)jsonStats) != null) {
                for (String key1 : JSONObject.getNames((JSONObject)jsonStats)) {
                    JSONObject jsonSubstats = jsonStats.getJSONObject(key1);
                    if (!cpStats.containsKey(key1)) {
                        cpStats.put(key1, new HashMap());
                    }
                    Map<String, Long> substats = cpStats.get(key1);
                    for (String key2 : JSONObject.getNames((JSONObject)jsonSubstats)) {
                        long value = jsonSubstats.getLong(key2);
                        substats.put(key2, value);
                    }
                }
                this.addStats(cpStats);
            }
        }
    }
}

