/*
 * Decompiled with CFR 0.152.
 */
package org.archive.modules.writer;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.archive.checkpointing.Checkpoint;
import org.archive.checkpointing.Checkpointable;
import org.archive.io.WriterPool;
import org.archive.io.WriterPoolSettings;
import org.archive.modules.CrawlMetadata;
import org.archive.modules.CrawlURI;
import org.archive.modules.ProcessResult;
import org.archive.modules.Processor;
import org.archive.modules.deciderules.recrawl.IdenticalDigestDecideRule;
import org.archive.modules.net.CrawlHost;
import org.archive.modules.net.ServerCache;
import org.archive.spring.ConfigPath;
import org.archive.util.FileUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.Lifecycle;

public abstract class WriterPoolProcessor
extends Processor
implements Lifecycle,
Checkpointable,
WriterPoolSettings {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(WriterPoolProcessor.class.getName());
    protected boolean compress = true;
    protected String prefix = "WEB";
    protected String template = "${prefix}-${timestamp17}-${serialno}-${heritrix.pid}~${heritrix.hostname}~${heritrix.port}";
    protected long maxFileSizeBytes = this.getDefaultMaxFileSize();
    protected int poolMaxActive = 1;
    protected int maxWaitForIdleMs = 500;
    protected boolean skipIdenticalDigests = false;
    protected static final String ANNOTATION_UNWRITTEN = "unwritten";
    protected long maxTotalBytesToWrite = 0L;
    protected boolean frequentFlushes = true;
    protected int writeBufferSize = 262144;
    protected transient ServerCache serverCache;
    protected ConfigPath directory = new ConfigPath("writer base path", "${launchId}");
    protected boolean startNewFilesOnCheckpoint = true;
    protected List<ConfigPath> storePaths = this.getDefaultStorePaths();
    private transient WriterPool pool = null;
    private AtomicLong totalBytesWritten = new AtomicLong();
    private AtomicInteger serial = new AtomicInteger();

    public boolean getCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    protected abstract long getDefaultMaxFileSize();

    public long getMaxFileSizeBytes() {
        return this.maxFileSizeBytes;
    }

    public void setMaxFileSizeBytes(long maxFileSizeBytes) {
        this.maxFileSizeBytes = maxFileSizeBytes;
    }

    public int getPoolMaxActive() {
        return this.poolMaxActive;
    }

    public void setPoolMaxActive(int poolMaxActive) {
        this.poolMaxActive = poolMaxActive;
    }

    public int getMaxWaitForIdleMs() {
        return this.maxWaitForIdleMs;
    }

    public void setMaxWaitForIdleMs(int maxWaitForIdle) {
        this.maxWaitForIdleMs = maxWaitForIdle;
    }

    public boolean getSkipIdenticalDigests() {
        return this.skipIdenticalDigests;
    }

    public void setSkipIdenticalDigests(boolean skipIdenticalDigests) {
        this.skipIdenticalDigests = skipIdenticalDigests;
    }

    public long getMaxTotalBytesToWrite() {
        return this.maxTotalBytesToWrite;
    }

    public void setMaxTotalBytesToWrite(long maxTotalBytesToWrite) {
        this.maxTotalBytesToWrite = maxTotalBytesToWrite;
    }

    public boolean getFrequentFlushes() {
        return this.frequentFlushes;
    }

    public void setFrequentFlushes(boolean frequentFlushes) {
        this.frequentFlushes = frequentFlushes;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    public CrawlMetadata getMetadataProvider() {
        return (CrawlMetadata)this.kp.get("metadataProvider");
    }

    @Autowired
    public void setMetadataProvider(CrawlMetadata provider) {
        this.kp.put((Object)"metadataProvider", (Object)provider);
    }

    public ServerCache getServerCache() {
        return this.serverCache;
    }

    @Autowired
    public void setServerCache(ServerCache serverCache) {
        this.serverCache = serverCache;
    }

    public ConfigPath getDirectory() {
        return this.directory;
    }

    public void setDirectory(ConfigPath directory) {
        this.directory = directory;
    }

    public boolean getStartNewFilesOnCheckpoint() {
        return this.startNewFilesOnCheckpoint;
    }

    public void setStartNewFilesOnCheckpoint(boolean startNewFilesOnCheckpoint) {
        this.startNewFilesOnCheckpoint = startNewFilesOnCheckpoint;
    }

    protected abstract List<ConfigPath> getDefaultStorePaths();

    public List<ConfigPath> getStorePaths() {
        return this.storePaths;
    }

    public void setStorePaths(List<ConfigPath> paths) {
        this.storePaths = paths;
    }

    @Override
    public synchronized void start() {
        if (this.isRunning()) {
            return;
        }
        super.start();
        this.setupPool(this.serial);
    }

    @Override
    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        super.stop();
        this.pool.close();
    }

    protected AtomicInteger getSerialNo() {
        return this.getPool().getSerialNo();
    }

    protected abstract void setupPool(AtomicInteger var1);

    protected ProcessResult checkBytesWritten() {
        long max = this.getMaxTotalBytesToWrite();
        if (max <= 0L) {
            return ProcessResult.PROCEED;
        }
        if (max <= this.getTotalBytesWritten()) {
            return ProcessResult.FINISH;
        }
        return ProcessResult.PROCEED;
    }

    protected boolean shouldWrite(CrawlURI curi) {
        boolean retVal;
        if (this.getSkipIdenticalDigests() && IdenticalDigestDecideRule.hasIdenticalDigest(curi)) {
            curi.getAnnotations().add("unwritten:identicalDigest");
            return false;
        }
        String scheme = curi.getUURI().getScheme().toLowerCase();
        if (scheme.equals("dns")) {
            retVal = curi.getFetchStatus() == 1;
        } else if (scheme.equals("whois")) {
            retVal = curi.getFetchStatus() == 2001;
        } else if (scheme.equals("http") || scheme.equals("https")) {
            retVal = curi.getFetchStatus() > 0 && curi.isHttpTransaction();
        } else if (scheme.equals("ftp") || scheme.equals("sftp")) {
            retVal = curi.getFetchStatus() > 0;
        } else {
            logger.info("This writer does not write out scheme " + scheme + " content");
            curi.getAnnotations().add("unwritten:scheme");
            return false;
        }
        if (!retVal) {
            curi.getAnnotations().add("unwritten:status");
            return false;
        }
        return true;
    }

    @Deprecated
    protected String getHostAddress(CrawlURI curi) {
        if (curi.getServerIP() != null) {
            return curi.getServerIP();
        }
        CrawlHost h = this.getServerCache().getHostFor(curi.getUURI());
        if (h == null) {
            throw new NullPointerException("Crawlhost is null for " + curi + " " + curi.getVia());
        }
        InetAddress a = h.getIP();
        if (a == null) {
            throw new NullPointerException("Address is null for " + curi + " " + curi.getVia() + ". Address " + (h.getIpFetched() == -2L ? "was never looked up." : System.currentTimeMillis() - h.getIpFetched() + " ms ago."));
        }
        return h.getIP().getHostAddress();
    }

    @Override
    public void doCheckpoint(Checkpoint checkpointInProgress) throws IOException {
        if (this.getStartNewFilesOnCheckpoint()) {
            this.pool.close();
            super.doCheckpoint(checkpointInProgress);
            this.setupPool(this.serial);
        } else {
            this.pool.flush();
            super.doCheckpoint(checkpointInProgress);
        }
    }

    @Override
    protected JSONObject toCheckpointJson() throws JSONException {
        JSONObject json = super.toCheckpointJson();
        json.put("serialNumber", this.getSerialNo().get());
        json.put("poolStatus", (Object)this.pool.jsonStatus());
        return json;
    }

    @Override
    protected void fromCheckpointJson(JSONObject json) throws JSONException {
        super.fromCheckpointJson(json);
        this.serial.set(json.getInt("serialNumber"));
    }

    protected WriterPool getPool() {
        return this.pool;
    }

    protected void setPool(WriterPool pool) {
        this.pool = pool;
    }

    protected long getTotalBytesWritten() {
        return this.totalBytesWritten.get();
    }

    protected void setTotalBytesWritten(long totalBytesWritten) {
        this.totalBytesWritten.set(totalBytesWritten);
    }

    protected void addTotalBytesWritten(long bytesWritten) {
        this.totalBytesWritten.addAndGet(bytesWritten);
    }

    public abstract List<String> getMetadata();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> calcOutputDirs() {
        List<ConfigPath> list = this.getStorePaths();
        ArrayList<File> results = new ArrayList<File>();
        for (ConfigPath path : list) {
            path.setBase(this.getDirectory());
            File f = path.getFile();
            if (!f.exists()) {
                try {
                    WriterPoolProcessor writerPoolProcessor = this;
                    synchronized (writerPoolProcessor) {
                        FileUtils.ensureWriteableDirectory((File)f);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            results.add(f);
        }
        return results;
    }

    @Override
    protected void innerProcess(CrawlURI puri) {
        throw new AssertionError();
    }

    @Override
    protected abstract ProcessResult innerProcessResult(CrawlURI var1);

    @Override
    protected boolean shouldProcess(CrawlURI curi) {
        if (curi.getFetchStatus() <= 0) {
            return false;
        }
        long recordLength = curi.getContentSize();
        return recordLength > 0L;
    }

    protected void copyForwardWriteTagIfDupe(CrawlURI curi) {
        HashMap<String, Object>[] history;
        if (IdenticalDigestDecideRule.hasIdenticalDigest(curi) && (history = curi.getFetchHistory()) != null && history[1].containsKey("write-tag")) {
            history[0].put("write-tag", history[1].get("write-tag"));
        }
    }

    @Override
    protected void innerRejectProcess(CrawlURI curi) throws InterruptedException {
        this.copyForwardWriteTagIfDupe(curi);
    }
}

