/*
 * Decompiled with CFR 0.152.
 */
package org.archive.state;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.lang.SerializationUtils;
import org.archive.modules.CrawlURI;
import org.archive.net.UURI;
import org.archive.net.UURIFactory;
import org.archive.util.Recorder;
import org.archive.util.TmpDirTestCase;

public abstract class ModuleTestBase
extends TestCase {
    public ModuleTestBase() {
        this.getSourceCodeDir();
        this.getResourceDir();
    }

    protected File getSourceCodeDir() {
        return this.getProjectDir("src/main/java");
    }

    protected File getResourceDir() {
        return this.getProjectDir("src/main/resources");
    }

    private File getProjectDir(String path) {
        File r = new File(path);
        if (r.exists()) {
            return r;
        }
        String cname = ((Object)((Object)this)).getClass().getName();
        if (cname.startsWith("org.archive.processors")) {
            return new File("modules/" + path);
        }
        if (cname.startsWith("org.archive.deciderules")) {
            return new File("modules/" + path);
        }
        if (cname.startsWith("org.archive.crawler")) {
            return new File("engine/" + path);
        }
        return null;
    }

    protected Class<?> getModuleClass() {
        String myClassName = ((Object)((Object)this)).getClass().getCanonicalName();
        if (!myClassName.endsWith("Test")) {
            throw new UnsupportedOperationException("Cannot get module class of " + myClassName);
        }
        String moduleClassName = myClassName.substring(0, myClassName.length() - 4);
        try {
            return Class.forName(moduleClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected Object makeModule() throws Exception {
        return this.getModuleClass().newInstance();
    }

    public void testSerializationIfAppropriate() throws Exception {
        Object first = this.makeModule();
        if (!(first instanceof Serializable)) {
            return;
        }
        byte[] firstBytes = SerializationUtils.serialize((Serializable)((Serializable)first));
        Object second = SerializationUtils.deserialize((byte[])firstBytes);
        byte[] secondBytes = SerializationUtils.serialize((Serializable)((Serializable)second));
        Object third = SerializationUtils.deserialize((byte[])secondBytes);
        byte[] thirdBytes = SerializationUtils.serialize((Serializable)((Serializable)third));
        this.verifySerialization(first, firstBytes, third, thirdBytes);
    }

    protected void verifySerialization(Object first, byte[] firstBytes, Object second, byte[] secondBytes) throws Exception {
        ModuleTestBase.assertTrue((boolean)Arrays.equals(firstBytes, secondBytes));
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
    }

    protected Recorder getRecorder() throws IOException {
        if (Recorder.getHttpRecorder() == null) {
            Recorder httpRecorder = new Recorder(TmpDirTestCase.tmpDir(), ((Object)((Object)this)).getClass().getName(), 16384, 524288);
            Recorder.setHttpRecorder((Recorder)httpRecorder);
        }
        return Recorder.getHttpRecorder();
    }

    protected CrawlURI makeCrawlURI(String uri) throws URIException, IOException {
        UURI uuri = UURIFactory.getInstance((String)uri);
        CrawlURI curi = new CrawlURI(uuri);
        curi.setSeed(true);
        curi.setRecorder(this.getRecorder());
        return curi;
    }
}

