/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.core.proxy;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.ardulink.util.Preconditions;

public class ProxyConnectionToRemote
implements Closeable {
    private static final String PROXY_CONNECTION_SEPARATOR = "\n";
    private static final String NUMBER_OF_PORTS = "NUMBER_OF_PORTS=";
    private final String host;
    private final Socket socket;
    private final Scanner scanner;
    private final PrintWriter printWriter;

    public ProxyConnectionToRemote(String host, int port) throws IOException {
        this.host = host;
        this.socket = new Socket(host, port);
        this.scanner = new Scanner(this.socket.getInputStream()).useDelimiter(Pattern.quote(PROXY_CONNECTION_SEPARATOR));
        this.printWriter = new PrintWriter(this.socket.getOutputStream(), false);
    }

    public List<String> getPortList() throws IOException {
        this.send(Command.GET_PORT_LIST_CMD.getCommand());
        String numberOfPorts = (String)Preconditions.checkNotNull((Object)this.read(), (String)"invalid response from %s, got null", (Object[])new Object[]{this.host});
        Preconditions.checkState((boolean)numberOfPorts.startsWith(NUMBER_OF_PORTS), (String)"invalid response: did not start with %s", (Object[])new Object[]{NUMBER_OF_PORTS});
        int numOfPorts = Integer.parseInt(numberOfPorts.substring(NUMBER_OF_PORTS.length()));
        ArrayList<String> retvalue = new ArrayList<String>(numOfPorts);
        for (int i = 0; i < numOfPorts; ++i) {
            retvalue.add(this.read());
        }
        return retvalue;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public String read() throws IOException {
        return this.scanner.next();
    }

    public void send(String message) {
        this.printWriter.print(message);
        this.printWriter.print(PROXY_CONNECTION_SEPARATOR);
        this.printWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.scanner.close();
        this.printWriter.close();
        this.socket.close();
    }

    public static enum Command {
        GET_PORT_LIST_CMD("get_port_list"),
        CONNECT_CMD("connect");

        private final String command;

        private Command(String command) {
            this.command = String.format("ardulink:networkproxyserver:%s", command);
        }

        public String getCommand() {
            return this.command;
        }

        public String toString() {
            return this.getCommand();
        }
    }
}

