/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.core.proxy;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.Max;
import javax.validation.constraints.Positive;
import org.ardulink.core.linkmanager.LinkConfig;
import org.ardulink.core.proxy.ProxyConnectionToRemote;

@LinkConfig.I18n(value="message")
public class ProxyLinkConfig
implements LinkConfig {
    private static final String NAMED_TCPHOST = "tcphost";
    private static final String NAMED_TCPPORT = "tcpport";
    private static final String NAMED_PORT = "port";
    private static final int DEFAULT_LISTENING_PORT = 4478;
    private static final int DEFAULT_SPEED = 115200;
    @LinkConfig.Named(value="tcphost")
    public String tcphost;
    @LinkConfig.Named(value="tcpport")
    @Positive
    @Max(value=65536L)
    public @Positive @Max(value=65536L) int tcpport = 4478;
    @LinkConfig.Named(value="port")
    public String port;
    @LinkConfig.Named(value="speed")
    @Positive
    public int speed = 115200;
    private ProxyConnectionToRemote remote;

    @LinkConfig.ChoiceFor(value="port", dependsOn={"tcphost", "tcpport"})
    public List<String> getAvailablePorts() throws IOException {
        return this.tcphost == null ? Collections.emptyList() : this.getRemoteInternal().getPortList();
    }

    public synchronized ProxyConnectionToRemote getRemote() throws IOException {
        ProxyConnectionToRemote result = this.getRemoteInternal();
        this.remote = null;
        return result;
    }

    private ProxyConnectionToRemote getRemoteInternal() throws IOException {
        if (this.remote == null) {
            this.remote = new ProxyConnectionToRemote(this.tcphost, this.tcpport);
        }
        return this.remote;
    }
}

