/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.core.proxy;

import java.io.IOException;
import java.net.Socket;
import org.ardulink.core.Connection;
import org.ardulink.core.ConnectionBasedLink;
import org.ardulink.core.StreamConnection;
import org.ardulink.core.linkmanager.LinkFactory;
import org.ardulink.core.proto.api.Protocols;
import org.ardulink.core.proxy.ProxyConnectionToRemote;
import org.ardulink.core.proxy.ProxyLinkConfig;
import org.ardulink.util.Preconditions;

public class ProxyLinkFactory
implements LinkFactory<ProxyLinkConfig> {
    public static final String OK = "OK";

    public String getName() {
        return "proxy";
    }

    public ConnectionBasedLink newLink(ProxyLinkConfig config) throws IOException {
        final ProxyConnectionToRemote remote = config.getRemote();
        remote.send(ProxyConnectionToRemote.Command.CONNECT_CMD.getCommand());
        remote.send((String)Preconditions.checkNotNull((Object)config.port, (String)"port must not be null", (Object[])new Object[0]));
        remote.send(String.valueOf(config.speed));
        String response = remote.read();
        Preconditions.checkState((boolean)OK.equals(response), (String)"Did not receive %s from remote, got %s", (Object[])new Object[]{OK, response});
        Socket socket = remote.getSocket();
        return new ConnectionBasedLink((Connection)new StreamConnection(socket.getInputStream(), socket.getOutputStream(), Protocols.protoByName((String)"ardulink2").newByteStreamProcessor())){

            public void close() throws IOException {
                super.close();
                remote.close();
            }
        };
    }

    public ProxyLinkConfig newLinkConfig() {
        return new ProxyLinkConfig();
    }
}

