/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.gui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import org.ardulink.core.Pin;
import org.ardulink.core.events.AnalogPinValueChangedEvent;
import org.ardulink.core.events.EventListener;
import org.ardulink.core.events.EventListenerAdapter;
import org.ardulink.core.events.FilteredEventListenerAdapter;
import org.ardulink.gui.Linkable;
import org.ardulink.gui.facility.IntMinMaxModel;
import org.ardulink.legacy.Link;

public class AnalogPinStatus
extends JPanel
implements Linkable {
    private static final Font FONT_11 = new Font("SansSerif", 0, 11);
    private static final Font FONT_12 = new Font("SansSerif", 0, 12);
    private static final long serialVersionUID = 7927439571760351922L;
    private JLabel valueLabel;
    private JLabel voltValueLbl;
    private JProgressBar progressBar;
    private JComboBox<Integer> minValueComboBox;
    private IntMinMaxModel minValueComboBoxModel;
    private JComboBox<Integer> maxValueComboBox;
    private IntMinMaxModel maxValueComboBoxModel;
    private JComboBox<Integer> pinComboBox;
    private IntMinMaxModel pinComboBoxModel;
    private JLabel lblPowerPinController;
    private JToggleButton tglbtnSensor;
    private transient EventListener listener;
    private transient Link link;

    private FilteredEventListenerAdapter listener() {
        return new FilteredEventListenerAdapter((Pin)Pin.analogPin((int)this.pinComboBoxModel.getSelectedItem()), (EventListener)new EventListenerAdapter(){

            public void stateChanged(AnalogPinValueChangedEvent event) {
                Integer value = event.getValue();
                AnalogPinStatus.this.valueLabel.setText(String.valueOf(value));
                float volt = (float)value.intValue() * 5.0f / 1023.0f;
                AnalogPinStatus.this.voltValueLbl.setText(volt + "V");
                float progress = (float)(value - AnalogPinStatus.this.getMinValue()) * 100.0f / ((float)AnalogPinStatus.this.getMaxValue() - (float)AnalogPinStatus.this.getMinValue());
                AnalogPinStatus.this.progressBar.setValue((int)progress);
            }
        });
    }

    public AnalogPinStatus() {
        this.setPreferredSize(new Dimension(140, 260));
        this.setLayout(null);
        JLabel lblPowerPin = new JLabel("Power Pin:");
        lblPowerPin.setFont(FONT_11);
        lblPowerPin.setBounds(10, 40, 59, 14);
        this.add(lblPowerPin);
        this.pinComboBoxModel = new IntMinMaxModel(0, 40);
        this.pinComboBox = new JComboBox<Integer>(this.pinComboBoxModel);
        this.pinComboBox.setSelectedItem(0);
        this.pinComboBox.setBounds(65, 36, 62, 22);
        this.add(this.pinComboBox);
        this.maxValueComboBoxModel = new IntMinMaxModel(0, 1023).withLastItemSelected();
        this.maxValueComboBox = new JComboBox<Integer>(this.maxValueComboBoxModel);
        this.maxValueComboBox.setBounds(65, 65, 62, 22);
        this.add(this.maxValueComboBox);
        this.minValueComboBoxModel = new IntMinMaxModel(0, 1023).withFirstItemSelected();
        this.minValueComboBox = new JComboBox<Integer>(this.minValueComboBoxModel);
        this.minValueComboBox.setBounds(65, 217, 62, 22);
        this.add(this.minValueComboBox);
        JLabel lblMaxValue = new JLabel("Max Value:");
        lblMaxValue.setFont(FONT_11);
        lblMaxValue.setBounds(10, 69, 59, 14);
        this.add(lblMaxValue);
        JLabel lblMinValue = new JLabel("Min Value:");
        lblMinValue.setFont(FONT_11);
        lblMinValue.setBounds(10, 221, 59, 14);
        this.add(lblMinValue);
        this.progressBar = new JProgressBar();
        this.progressBar.setFont(FONT_11);
        this.progressBar.setStringPainted(true);
        this.progressBar.setCursor(Cursor.getPredefinedCursor(0));
        this.progressBar.setOrientation(1);
        this.progressBar.setBounds(111, 99, 16, 108);
        this.add(this.progressBar);
        this.lblPowerPinController = new JLabel("Analog PIN Status");
        this.lblPowerPinController.setFont(FONT_12);
        this.lblPowerPinController.setToolTipText("");
        this.lblPowerPinController.setHorizontalAlignment(0);
        this.lblPowerPinController.setBounds(10, 11, 117, 14);
        this.add(this.lblPowerPinController);
        JLabel lblVoltOutput = new JLabel("Volt Output:");
        lblVoltOutput.setFont(FONT_11);
        lblVoltOutput.setBounds(10, 143, 59, 14);
        this.add(lblVoltOutput);
        this.voltValueLbl = new JLabel("0V");
        this.voltValueLbl.setFont(FONT_11);
        this.voltValueLbl.setBounds(10, 157, 76, 14);
        this.add(this.voltValueLbl);
        JLabel lblCurrentValue = new JLabel("Current Value:");
        lblCurrentValue.setFont(FONT_11);
        lblCurrentValue.setBounds(10, 98, 76, 14);
        this.add(lblCurrentValue);
        this.valueLabel = new JLabel();
        this.valueLabel.setBounds(10, 112, 55, 22);
        this.valueLabel.setText("0");
        this.add(this.valueLabel);
        this.tglbtnSensor = new JToggleButton("Off");
        this.tglbtnSensor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AnalogPinStatus.this.link.addAnalogReadChangeListener(AnalogPinStatus.this.listener = (EventListener)AnalogPinStatus.this.listener());
                    AnalogPinStatus.this.tglbtnSensor.setText("On");
                    AnalogPinStatus.this.pinComboBox.setEnabled(false);
                    AnalogPinStatus.this.minValueComboBox.setEnabled(false);
                    AnalogPinStatus.this.maxValueComboBox.setEnabled(false);
                    AnalogPinStatus.this.progressBar.setEnabled(true);
                } else if (e.getStateChange() == 2) {
                    AnalogPinStatus.this.link.removeAnalogReadChangeListener(AnalogPinStatus.this.listener);
                    AnalogPinStatus.this.tglbtnSensor.setText("Off");
                    AnalogPinStatus.this.pinComboBox.setEnabled(true);
                    AnalogPinStatus.this.minValueComboBox.setEnabled(true);
                    AnalogPinStatus.this.maxValueComboBox.setEnabled(true);
                    AnalogPinStatus.this.progressBar.setEnabled(false);
                }
            }
        });
        this.tglbtnSensor.setBounds(10, 177, 76, 28);
        this.add(this.tglbtnSensor);
        this.minValueComboBox.addActionListener(e -> {
            int maximum = this.getMaxValue();
            int minimum = this.getMinValue();
            if (minimum > maximum) {
                this.minValueComboBoxModel.setSelectedItem(maximum);
            }
            this.updateValue();
        });
        this.maxValueComboBox.addActionListener(e -> {
            int maximum = this.getMaxValue();
            int minimum = this.getMinValue();
            if (minimum > maximum) {
                this.maxValueComboBoxModel.setSelectedItem(minimum);
            }
            this.updateValue();
        });
    }

    public void setPin(int pin) {
        this.pinComboBoxModel.setSelectedItem(pin);
    }

    @Override
    public void setLink(Link link) {
        if (this.link != null && this.listener != null) {
            this.link.removeAnalogReadChangeListener(this.listener);
        }
        this.link = link;
    }

    public void setTitle(String title) {
        this.lblPowerPinController.setText(title);
    }

    public int getValue() {
        return Integer.parseInt(this.valueLabel.getText());
    }

    public void setValue(int value) {
        this.valueLabel.setText(String.valueOf(Math.max(this.getMinValue(), Math.min(value, this.getMaxValue()))));
    }

    public int getMinValue() {
        return this.minValueComboBoxModel.getSelectedItem();
    }

    public int getMaxValue() {
        return this.maxValueComboBoxModel.getSelectedItem();
    }

    private void updateValue() {
        this.setValue(this.getValue());
    }
}

