/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class ColorChooserDialog
extends JDialog {
    private static final long serialVersionUID = -9016876523594283575L;
    private Color color;

    public Color getColor() {
        return this.color;
    }

    public static void main(String[] args) {
        ColorChooserDialog dialog = new ColorChooserDialog(Color.black);
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
    }

    public ColorChooserDialog(Color color) {
        this.color = color;
        this.setModal(true);
        this.setTitle("Color Chooser");
        this.setBounds(100, 100, 450, 300);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        JColorChooser colorChooser = new JColorChooser();
        colorChooser.setColor(color);
        contentPanel.setLayout(new BorderLayout());
        contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)contentPanel, "Center");
        this.buttons(colorChooser);
        contentPanel.add((Component)colorChooser, "Center");
        this.pack();
    }

    private void buttons(JColorChooser colorChooser) {
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = this.okButton(colorChooser);
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        buttonPane.add(this.cancelButton());
    }

    private JButton cancelButton() {
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> {
            this.setVisible(false);
            this.dispose();
        });
        return cancelButton;
    }

    private JButton okButton(JColorChooser colorChooser) {
        JButton okButton = new JButton("OK");
        okButton.addActionListener(e -> {
            this.color = colorChooser.getColor();
            this.setVisible(false);
            this.dispose();
        });
        return okButton;
    }
}

