/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.gui;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.ardulink.core.ConnectionListener;
import org.ardulink.gui.Linkable;
import org.ardulink.legacy.Link;

public class ConnectionStatus
extends JPanel
implements Linkable {
    private static final String ICON_FOLDER = "icons/";
    private static final long serialVersionUID = 6630818070505677116L;
    private JLabel lblStatelabel;
    private static final String CONNECTED_TEXT = "connected";
    private static final String DISCONNECTED_TEXT = "disconnected";
    private static final ImageIcon CONNECTED_ICON = ConnectionStatus.loadIcon("connect_established.png");
    private static final ImageIcon DISCONNECTED_ICON = ConnectionStatus.loadIcon("connect_no.png");
    private transient Link link = Link.NO_LINK;
    private final transient ConnectionListener connectionListener = new ConnectionListener(){

        public void connectionLost() {
            ConnectionStatus.this.lblStatelabel.setText(ConnectionStatus.DISCONNECTED_TEXT);
            ConnectionStatus.this.lblStatelabel.setIcon(DISCONNECTED_ICON);
        }

        public void reconnected() {
            ConnectionStatus.this.lblStatelabel.setText(ConnectionStatus.CONNECTED_TEXT);
            ConnectionStatus.this.lblStatelabel.setIcon(CONNECTED_ICON);
        }
    };

    private static ImageIcon loadIcon(String iconName) {
        return new ImageIcon(ConnectionStatus.class.getResource(ICON_FOLDER + iconName));
    }

    public ConnectionStatus() {
        this.lblStatelabel = new JLabel();
        this.connectionListener.connectionLost();
        this.add(this.lblStatelabel);
    }

    @Override
    public void setLink(Link newLink) {
        if (this.link != null) {
            this.link.removeConnectionListener(this.connectionListener);
        }
        this.link = newLink;
        if (this.link != null) {
            this.link.addConnectionListener(this.connectionListener);
        }
        if (this.link == null || this.link == Link.NO_LINK) {
            this.connectionListener.connectionLost();
        } else {
            this.connectionListener.reconnected();
        }
    }
}

