/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.gui;

import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.ardulink.core.Pin;
import org.ardulink.core.events.DigitalPinValueChangedEvent;
import org.ardulink.core.events.EventListener;
import org.ardulink.core.events.EventListenerAdapter;
import org.ardulink.core.events.FilteredEventListenerAdapter;
import org.ardulink.gui.Linkable;
import org.ardulink.gui.facility.IntMinMaxModel;
import org.ardulink.legacy.Link;

public class DigitalPinStatus
extends JPanel
implements Linkable {
    private static final String SENSOR_OFF = "Sensor off";
    private static final long serialVersionUID = -7773514191770737230L;
    private JLabel lblStatelabel;
    private JToggleButton tglbtnSensor;
    private JComboBox<Integer> pinComboBox;
    private IntMinMaxModel pinComboBoxModel;
    private JLabel lblPin;
    private transient Link link;
    private static final String HIGH = "High";
    private static final String LOW = "Low";
    private static final String HIGH_ICON_NAME = "icons/blue-on-32.png";
    private static final String LOW_ICON_NAME = "icons/blue-off-32.png";
    private static final ImageIcon HIGH_ICON = new ImageIcon(DigitalPinStatus.class.getResource("icons/blue-on-32.png"));
    private static final ImageIcon LOW_ICON = new ImageIcon(DigitalPinStatus.class.getResource("icons/blue-off-32.png"));
    private JPanel comboPanel;
    private transient EventListener listener;

    private FilteredEventListenerAdapter listener() {
        return new FilteredEventListenerAdapter((Pin)Pin.digitalPin((int)this.pinComboBoxModel.getSelectedItem()), (EventListener)new EventListenerAdapter(){

            public void stateChanged(DigitalPinValueChangedEvent event) {
                boolean value = event.getValue();
                DigitalPinStatus.this.lblStatelabel.setText(value ? DigitalPinStatus.HIGH : DigitalPinStatus.LOW);
                DigitalPinStatus.this.lblStatelabel.setIcon(value ? HIGH_ICON : LOW_ICON);
            }
        });
    }

    public DigitalPinStatus() {
        this.setLayout(new GridLayout(3, 1, 0, 0));
        this.lblStatelabel = new JLabel(LOW);
        this.lblStatelabel.setHorizontalAlignment(0);
        this.lblStatelabel.setIcon(LOW_ICON);
        this.lblStatelabel.setEnabled(false);
        this.add(this.lblStatelabel);
        this.comboPanel = new JPanel();
        this.add(this.comboPanel);
        this.lblPin = new JLabel("Pin:");
        this.comboPanel.add(this.lblPin);
        this.pinComboBoxModel = new IntMinMaxModel(2, 40);
        this.pinComboBox = new JComboBox<Integer>(this.pinComboBoxModel);
        this.comboPanel.add(this.pinComboBox);
        this.tglbtnSensor = new JToggleButton(SENSOR_OFF);
        this.tglbtnSensor.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DigitalPinStatus.this.link.addDigitalReadChangeListener(DigitalPinStatus.this.listener = (EventListener)DigitalPinStatus.this.listener());
                    DigitalPinStatus.this.tglbtnSensor.setText("Sensor on");
                    DigitalPinStatus.this.pinComboBox.setEnabled(false);
                    DigitalPinStatus.this.lblStatelabel.setEnabled(true);
                } else if (e.getStateChange() == 2) {
                    DigitalPinStatus.this.link.removeDigitalReadChangeListener(DigitalPinStatus.this.listener);
                    DigitalPinStatus.this.tglbtnSensor.setText(DigitalPinStatus.SENSOR_OFF);
                    DigitalPinStatus.this.pinComboBox.setEnabled(true);
                    DigitalPinStatus.this.lblStatelabel.setEnabled(false);
                }
            }
        });
        this.add(this.tglbtnSensor);
    }

    public void setPin(int pin) {
        this.pinComboBoxModel.setSelectedItem(pin);
    }

    @Override
    public void setLink(Link link) {
        if (this.link != null && this.listener != null) {
            this.link.removeDigitalReadChangeListener(this.listener);
        }
        this.tglbtnSensor.setText(SENSOR_OFF);
        this.pinComboBox.setEnabled(true);
        this.lblStatelabel.setEnabled(false);
        this.link = link;
    }
}

