/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.gui;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JLabel;
import org.ardulink.legacy.Link;

public class KeyPressListener
extends KeyAdapter {
    private JLabel guiInteractionLabel;
    private Link link;

    public JLabel getGuiInteractionLabel() {
        return this.guiInteractionLabel;
    }

    public void setGuiInteractionLabel(JLabel guiInteractionLabel) {
        this.guiInteractionLabel = guiInteractionLabel;
    }

    public void removeGuiInteractionLabel() {
        this.guiInteractionLabel = null;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.keyPressedGUIInteraction(e);
        this.link.sendKeyPressEvent(e.getKeyChar(), e.getKeyCode(), e.getKeyLocation(), e.getModifiers(), e.getModifiersEx());
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.keyReleasedGUIInteraction();
    }

    private void keyPressedGUIInteraction(KeyEvent e) {
        if (this.guiInteractionLabel != null) {
            String text = this.computeText4GUIInteraction(e);
            this.guiInteractionLabel.setText(text);
        }
    }

    private String computeText4GUIInteraction(KeyEvent e) {
        return String.format("Char: %c - Key Code: %d - Key Location: %d - Modifiers: %d - Modifiers Ex: %d", Character.valueOf(e.getKeyChar()), e.getKeyCode(), e.getKeyLocation(), e.getModifiers(), e.getModifiersEx());
    }

    private void keyReleasedGUIInteraction() {
        if (this.guiInteractionLabel != null) {
            this.guiInteractionLabel.setText("");
        }
    }

    public void setLink(Link link) {
        this.link = link;
    }
}

