/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.gui;

import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ardulink.gui.Linkable;
import org.ardulink.gui.event.PWMChangeEvent;
import org.ardulink.gui.event.PWMControllerListener;
import org.ardulink.gui.facility.IntMinMaxModel;
import org.ardulink.legacy.Link;

public class PWMController
extends JPanel
implements Linkable {
    private static final Font FONT_11 = new Font("SansSerif", 0, 11);
    private static final Font FONT_12 = new Font("SansSerif", 0, 12);
    private static final long serialVersionUID = 7927439571760351922L;
    private JSlider powerSlider;
    private JComboBox<Integer> valueComboBox;
    private IntMinMaxModel valueComboBoxModel;
    private JLabel voltValueLbl;
    private JCheckBox chckbxContChange;
    private JProgressBar progressBar;
    private IntMinMaxModel maxValueComboBoxModel;
    private IntMinMaxModel minValueComboBoxModel;
    private JComboBox<Integer> pinComboBox;
    private JLabel lblPowerPinController;
    private List<PWMControllerListener> pwmControllerListeners = new ArrayList<PWMControllerListener>();
    private transient Link link;

    public PWMController() {
        this.setPreferredSize(new Dimension(195, 260));
        this.setLayout(null);
        this.powerSlider = new JSlider();
        this.powerSlider.setFont(FONT_11);
        this.powerSlider.setMajorTickSpacing(15);
        this.powerSlider.setPaintLabels(true);
        this.powerSlider.setPaintTicks(true);
        this.powerSlider.setMaximum(255);
        this.powerSlider.setValue(0);
        this.powerSlider.setOrientation(1);
        this.powerSlider.setBounds(126, 38, 59, 199);
        this.add(this.powerSlider);
        JLabel lblPowerPin = new JLabel("Power Pin:");
        lblPowerPin.setFont(FONT_11);
        lblPowerPin.setBounds(10, 40, 59, 14);
        this.add(lblPowerPin);
        IntMinMaxModel pinComboBoxModel = new IntMinMaxModel(0, 40);
        this.pinComboBox = new JComboBox<Integer>(pinComboBoxModel);
        this.pinComboBox.setSelectedItem(11);
        this.pinComboBox.setBounds(65, 36, 55, 22);
        this.add(this.pinComboBox);
        this.maxValueComboBoxModel = new IntMinMaxModel(0, 1023).withSelectedItem(255);
        JComboBox<Integer> maxValueComboBox = new JComboBox<Integer>(this.maxValueComboBoxModel);
        maxValueComboBox.setBounds(65, 65, 55, 22);
        this.add(maxValueComboBox);
        this.minValueComboBoxModel = new IntMinMaxModel(0, 1023).withFirstItemSelected();
        JComboBox<Integer> minValueComboBox = new JComboBox<Integer>(this.minValueComboBoxModel);
        minValueComboBox.setBounds(65, 217, 55, 22);
        this.add(minValueComboBox);
        JLabel lblMaxValue = new JLabel("Max Value:");
        lblMaxValue.setFont(FONT_11);
        lblMaxValue.setBounds(10, 69, 59, 14);
        this.add(lblMaxValue);
        JLabel lblMinValue = new JLabel("Min Value:");
        lblMinValue.setFont(FONT_11);
        lblMinValue.setBounds(10, 221, 59, 14);
        this.add(lblMinValue);
        this.progressBar = new JProgressBar();
        this.progressBar.setFont(FONT_11);
        this.progressBar.setStringPainted(true);
        this.progressBar.setCursor(Cursor.getPredefinedCursor(0));
        this.progressBar.setOrientation(1);
        this.progressBar.setBounds(96, 98, 16, 108);
        this.add(this.progressBar);
        this.lblPowerPinController = new JLabel("Power Pin Controller");
        this.lblPowerPinController.setFont(FONT_12);
        this.lblPowerPinController.setToolTipText("Power With Modulation");
        this.lblPowerPinController.setHorizontalAlignment(0);
        this.lblPowerPinController.setBounds(10, 11, 175, 14);
        this.add(this.lblPowerPinController);
        JLabel lblVoltOutput = new JLabel("Volt Output:");
        lblVoltOutput.setFont(FONT_11);
        lblVoltOutput.setBounds(10, 143, 59, 14);
        this.add(lblVoltOutput);
        this.voltValueLbl = new JLabel("0V");
        this.voltValueLbl.setFont(FONT_11);
        this.voltValueLbl.setBounds(10, 157, 76, 14);
        this.add(this.voltValueLbl);
        JLabel lblCurrentValue = new JLabel("Current Value:");
        lblCurrentValue.setFont(FONT_11);
        lblCurrentValue.setBounds(10, 98, 76, 14);
        this.add(lblCurrentValue);
        this.valueComboBoxModel = new IntMinMaxModel(0, 255).withFirstItemSelected();
        this.valueComboBox = new JComboBox<Integer>(this.valueComboBoxModel);
        this.valueComboBox.addActionListener(e -> {
            int powerSliderCurrentValue;
            int comboBoxCurrentValue = this.valueComboBoxModel.getSelectedItem();
            if (comboBoxCurrentValue != (powerSliderCurrentValue = this.powerSlider.getValue())) {
                this.powerSlider.setValue(comboBoxCurrentValue);
            }
        });
        this.valueComboBox.setBounds(10, 112, 55, 22);
        this.add(this.valueComboBox);
        JLabel lblContinuousChange = new JLabel("Cont. Change:");
        lblContinuousChange.setFont(FONT_11);
        lblContinuousChange.setToolTipText("Continuous Change");
        lblContinuousChange.setBounds(10, 176, 73, 14);
        this.add(lblContinuousChange);
        this.chckbxContChange = new JCheckBox("");
        this.chckbxContChange.setRequestFocusEnabled(false);
        this.chckbxContChange.setRolloverEnabled(true);
        this.chckbxContChange.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.chckbxContChange.setSelected(true);
        this.chckbxContChange.setBounds(6, 188, 21, 22);
        this.add(this.chckbxContChange);
        this.powerSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!PWMController.this.powerSlider.getValueIsAdjusting() || PWMController.this.chckbxContChange.isSelected()) {
                    int powerValue = PWMController.this.powerSlider.getValue();
                    PWMController.this.valueComboBoxModel.setSelectedItem(powerValue);
                    float volt = (float)powerValue * 5.0f / 255.0f;
                    PWMController.this.voltValueLbl.setText(volt + "V");
                    float progress = (float)(powerValue - PWMController.this.powerSlider.getMinimum()) * 100.0f / ((float)PWMController.this.powerSlider.getMaximum() - (float)PWMController.this.powerSlider.getMinimum());
                    PWMController.this.progressBar.setValue((int)progress);
                    PWMController.this.notifyListeners(powerValue);
                    int pin = (Integer)PWMController.this.pinComboBox.getSelectedItem();
                    PWMController.this.link.sendPowerPinIntensity(pin, powerValue);
                }
            }
        });
        minValueComboBox.addActionListener(e -> {
            int maximum = this.maxValueComboBoxModel.getSelectedItem();
            int minimum = this.minValueComboBoxModel.getSelectedItem();
            if (minimum > maximum) {
                this.minValueComboBoxModel.setSelectedItem(maximum);
            }
            this.valueComboBoxModel = new IntMinMaxModel(minimum, maximum);
            this.valueComboBox.setModel(this.valueComboBoxModel);
            this.powerSlider.setPaintLabels(false);
            this.powerSlider.setPaintTicks(false);
            this.powerSlider.setMajorTickSpacing((maximum - minimum) / 18);
            this.powerSlider.setMinimum(minimum);
            this.powerSlider.setPaintLabels(true);
            this.powerSlider.setPaintTicks(true);
        });
        maxValueComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int maximum = PWMController.this.maxValueComboBoxModel.getSelectedItem();
                int minimum = PWMController.this.minValueComboBoxModel.getSelectedItem();
                if (minimum > maximum) {
                    PWMController.this.maxValueComboBoxModel.setSelectedItem(minimum);
                }
                PWMController.this.valueComboBoxModel = new IntMinMaxModel(minimum, maximum);
                PWMController.this.valueComboBox.setModel(PWMController.this.valueComboBoxModel);
                PWMController.this.powerSlider.setPaintLabels(false);
                PWMController.this.powerSlider.setPaintTicks(false);
                PWMController.this.powerSlider.setMajorTickSpacing((maximum - minimum) / 18);
                PWMController.this.powerSlider.setMaximum(maximum);
                PWMController.this.powerSlider.setPaintLabels(true);
                PWMController.this.powerSlider.setPaintTicks(true);
            }
        });
    }

    public void setPin(int pin) {
        this.pinComboBox.setSelectedItem(pin);
    }

    @Override
    public void setLink(Link link) {
        this.link = link;
    }

    public void setTitle(String title) {
        this.lblPowerPinController.setText(title);
    }

    public boolean addPWMControllerListener(PWMControllerListener listener) {
        return this.pwmControllerListeners.add(listener);
    }

    public boolean removePWMControllerListener(PWMControllerListener listener) {
        return this.pwmControllerListeners.remove(listener);
    }

    private void notifyListeners(int powerValue) {
        PWMChangeEvent event = new PWMChangeEvent(powerValue);
        for (PWMControllerListener pwmControllerListener : this.pwmControllerListeners) {
            pwmControllerListener.pwmChanged(event);
        }
    }

    public int getValue() {
        return this.valueComboBoxModel.getSelectedItem();
    }

    public void setValue(int value) {
        int maximum = this.maxValueComboBoxModel.getSelectedItem();
        int minimum = this.minValueComboBoxModel.getSelectedItem();
        this.valueComboBoxModel.setSelectedItem(Math.max(Math.min(value, maximum), minimum));
    }
}

