/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.ardulink.gui.ColorChooserDialog;
import org.ardulink.gui.Linkable;
import org.ardulink.gui.PWMController;
import org.ardulink.gui.event.PWMChangeEvent;
import org.ardulink.gui.event.PWMControllerListener;
import org.ardulink.gui.facility.UtilityColor;
import org.ardulink.legacy.Link;

public class RGBController
extends JPanel
implements Linkable {
    private final transient DocumentListener colorTextFieldDocumentListener = new DocumentListener(){

        @Override
        public void removeUpdate(DocumentEvent e) {
            RGBController.this.updateColor();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            RGBController.this.updateColor();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            RGBController.this.updateColor();
        }
    };
    private static final long serialVersionUID = -4822268873266363743L;
    private PWMController redController;
    private PWMController greenController;
    private PWMController blueController;
    private JPanel centralPanel;
    private final JPanel coloredPanel;
    private JPanel southPanel;
    private JLabel lblColor;
    private JTextField colorTextField;
    private JCheckBox chckbxInverted;
    private final transient PWMControllerListener redListener = new AbstractPWMControllerListener(){

        @Override
        protected Color makeColor(Color color, int value) {
            return new Color(value, color.getGreen(), color.getBlue());
        }
    };
    private final transient AbstractPWMControllerListener greenListener = new AbstractPWMControllerListener(){

        @Override
        protected Color makeColor(Color color, int value) {
            return new Color(color.getRed(), value, color.getBlue());
        }
    };
    private final transient AbstractPWMControllerListener blueListener = new AbstractPWMControllerListener(){

        @Override
        protected Color makeColor(Color color, int value) {
            return new Color(color.getRed(), color.getGreen(), value);
        }
    };

    public RGBController() {
        this.setPreferredSize(new Dimension(640, 315));
        this.setLayout(new BorderLayout(0, 0));
        this.centralPanel = new JPanel();
        this.add((Component)this.centralPanel, "Center");
        this.redController = new PWMController();
        this.redController.setTitle("Red");
        this.redController.setPin(2);
        this.redController.addPWMControllerListener(this.redListener);
        this.centralPanel.add(this.redController);
        this.greenController = new PWMController();
        this.greenController.setTitle("Green");
        this.greenController.setPin(1);
        this.greenController.addPWMControllerListener(this.greenListener);
        this.centralPanel.add(this.greenController);
        this.blueController = new PWMController();
        this.blueController.setTitle("Blue");
        this.blueController.setPin(0);
        this.blueController.addPWMControllerListener(this.blueListener);
        this.centralPanel.add(this.blueController);
        this.southPanel = new JPanel();
        this.add((Component)this.southPanel, "South");
        this.coloredPanel = new JPanel();
        this.coloredPanel.setToolTipText("click to open color dialog");
        this.coloredPanel.setBorder(new EtchedBorder(1, null, null));
        this.coloredPanel.setPreferredSize(new Dimension(150, 40));
        this.coloredPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ColorChooserDialog dialog = new ColorChooserDialog(RGBController.this.coloredPanel.getBackground());
                dialog.setDefaultCloseOperation(2);
                dialog.setVisible(true);
                RGBController.this.setColor(dialog.getColor());
            }
        });
        this.chckbxInverted = new JCheckBox("Inverted");
        this.chckbxInverted.addActionListener(e -> {
            Color newColor = this.invert(this.coloredPanel.getBackground());
            this.coloredPanel.setBackground(newColor);
            this.colorTextField.setText(UtilityColor.toString(newColor));
        });
        this.southPanel.add(this.chckbxInverted);
        this.southPanel.add(this.coloredPanel);
        this.coloredPanel.setBackground(new Color(this.redController.getValue(), this.greenController.getValue(), this.blueController.getValue()));
        this.lblColor = new JLabel("Color:");
        this.southPanel.add(this.lblColor);
        this.colorTextField = new JTextField();
        this.colorTextField.setText(UtilityColor.toString(this.coloredPanel.getBackground()));
        this.southPanel.add(this.colorTextField);
        this.colorTextField.setColumns(10);
        this.colorTextField.getDocument().addDocumentListener(this.colorTextFieldDocumentListener);
    }

    @Override
    public void setLink(Link link) {
        this.redController.setLink(link);
        this.greenController.setLink(link);
        this.blueController.setLink(link);
    }

    private void updateColor() {
        Color color = UtilityColor.toColor(this.colorTextField.getText());
        this.coloredPanel.setBackground(color);
        this.redController.removePWMControllerListener(this.redListener);
        this.greenController.removePWMControllerListener(this.greenListener);
        this.blueController.removePWMControllerListener(this.blueListener);
        if (this.chckbxInverted.isSelected()) {
            color = this.invert(color);
        }
        this.redController.setValue(color.getRed());
        this.greenController.setValue(color.getGreen());
        this.blueController.setValue(color.getBlue());
        this.redController.addPWMControllerListener(this.redListener);
        this.greenController.addPWMControllerListener(this.greenListener);
        this.blueController.addPWMControllerListener(this.blueListener);
    }

    private Color invert(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
    }

    public void setColor(Color color) {
        String colorString = UtilityColor.toString(color);
        this.colorTextField.setText(colorString);
        this.updateColor();
    }

    public abstract class AbstractPWMControllerListener
    implements PWMControllerListener {
        @Override
        public void pwmChanged(PWMChangeEvent event) {
            RGBController.this.colorTextField.getDocument().removeDocumentListener(RGBController.this.colorTextFieldDocumentListener);
            Color color = RGBController.this.coloredPanel.getBackground();
            int value = event.getPwmValue();
            if (RGBController.this.chckbxInverted.isSelected()) {
                value = 255 - value;
            }
            Color newColor = this.makeColor(color, value);
            RGBController.this.coloredPanel.setBackground(newColor);
            RGBController.this.colorTextField.setText(UtilityColor.toString(newColor));
            RGBController.this.colorTextField.getDocument().addDocumentListener(RGBController.this.colorTextFieldDocumentListener);
        }

        protected abstract Color makeColor(Color var1, int var2);
    }
}

