/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.gui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.ardulink.gui.Linkable;
import org.ardulink.gui.facility.IntMinMaxModel;
import org.ardulink.legacy.Link;

public class SwitchController
extends JPanel
implements Linkable {
    private static final long serialVersionUID = -260988038687002762L;
    private IntMinMaxModel pinComboBoxModel;
    private JToggleButton switchToggleButton;
    private transient Link link;

    public SwitchController() {
        this.setPreferredSize(new Dimension(125, 75));
        this.setLayout(null);
        this.pinComboBoxModel = new IntMinMaxModel(0, 40).withSelectedItem(3);
        JComboBox<Integer> pinComboBox = new JComboBox<Integer>(this.pinComboBoxModel);
        pinComboBox.setBounds(66, 11, 47, 22);
        this.add(pinComboBox);
        JLabel label = new JLabel("Power Pin:");
        label.setFont(new Font("SansSerif", 0, 11));
        label.setBounds(10, 15, 59, 14);
        this.add(label);
        this.switchToggleButton = new JToggleButton("Off");
        this.switchToggleButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                int pin = SwitchController.this.pinComboBoxModel.getSelectedItem();
                if (e.getStateChange() == 1) {
                    SwitchController.this.switchToggleButton.setText("On");
                    SwitchController.this.link.sendPowerPinSwitch(pin, true);
                } else if (e.getStateChange() == 2) {
                    SwitchController.this.switchToggleButton.setText("Off");
                    SwitchController.this.link.sendPowerPinSwitch(pin, false);
                }
            }
        });
        this.switchToggleButton.setBounds(10, 38, 103, 23);
        this.add(this.switchToggleButton);
    }

    public void setPin(int pin) {
        this.pinComboBoxModel.setSelectedItem(pin);
    }

    @Override
    public void setLink(Link link) {
        this.link = link;
    }
}

