/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import org.ardulink.gui.Linkable;
import org.ardulink.gui.facility.IntMinMaxModel;
import org.ardulink.legacy.Link;

public class ToneController
extends JPanel
implements Linkable {
    private static final long serialVersionUID = 1754259889096759199L;
    private transient Link link;
    private JSpinner frequencySpinner;
    private JToggleButton toneButton;
    private JPanel frequencyPanel;
    private JLabel frequencyLabel;
    private JPanel configPanel;
    private JPanel durationPanel;
    private JLabel durationLabel;
    private JSpinner durationSpinner;
    private String toneButtonOnText = "On";
    private String toneButtonOffText = "Off";
    private JCheckBox durationCheckBox;
    private IntMinMaxModel pinComboBoxModel;
    private JLabel pinLabel;
    private JPanel pinPanel;

    public ToneController() {
        this.setLayout(new BorderLayout(0, 0));
        this.configPanel = new JPanel();
        this.add((Component)this.configPanel, "North");
        this.configPanel.setLayout(new BoxLayout(this.configPanel, 1));
        this.pinPanel = new JPanel();
        FlowLayout flowLayout = (FlowLayout)this.pinPanel.getLayout();
        flowLayout.setAlignment(0);
        this.configPanel.add(this.pinPanel);
        this.pinLabel = new JLabel("Pin:");
        this.pinPanel.add(this.pinLabel);
        this.pinLabel.setFont(new Font("SansSerif", 0, 12));
        this.pinComboBoxModel = new IntMinMaxModel(0, 40);
        JComboBox<Integer> pinComboBox = new JComboBox<Integer>(this.pinComboBoxModel);
        this.pinPanel.add(pinComboBox);
        this.frequencyPanel = new JPanel();
        this.configPanel.add(this.frequencyPanel);
        this.frequencyPanel.setLayout(new BoxLayout(this.frequencyPanel, 0));
        this.frequencyLabel = new JLabel("Frequency (Hz):");
        this.frequencyLabel.setToolTipText("the frequency of the tone in hertz");
        this.frequencyLabel.setHorizontalAlignment(4);
        this.frequencyPanel.add(this.frequencyLabel);
        this.frequencySpinner = new JSpinner();
        this.frequencySpinner.setModel(new SpinnerNumberModel(31, 1, 65535, 1));
        this.frequencyPanel.add(this.frequencySpinner);
        this.durationPanel = new JPanel();
        this.configPanel.add(this.durationPanel);
        this.durationPanel.setLayout(new BoxLayout(this.durationPanel, 0));
        this.durationLabel = new JLabel("Duration (ms):");
        this.durationLabel.setToolTipText("the duration of the tone in milliseconds (optional)");
        this.durationLabel.setHorizontalAlignment(4);
        this.durationPanel.add(this.durationLabel);
        this.durationSpinner = new JSpinner();
        this.durationSpinner.setPreferredSize(new Dimension(105, 28));
        this.durationSpinner.setModel(new SpinnerNumberModel((Number)1000, Integer.valueOf(1), null, (Number)1));
        this.durationPanel.add(this.durationSpinner);
        this.durationCheckBox = new JCheckBox("Duration enabled");
        this.durationCheckBox.setSelected(true);
        this.durationCheckBox.addActionListener(e -> {
            this.durationLabel.setEnabled(this.durationCheckBox.isSelected());
            this.durationSpinner.setEnabled(this.durationCheckBox.isSelected());
        });
        this.durationPanel.add(this.durationCheckBox);
        this.toneButton = new JToggleButton("Off");
        this.toneButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Integer pin = ToneController.this.pinComboBoxModel.getSelectedItem();
                if (pin != null) {
                    if (e.getStateChange() == 1) {
                        Integer value = (Integer)ToneController.this.frequencySpinner.getValue();
                        if (ToneController.this.durationCheckBox.isSelected()) {
                            ToneController.this.link.sendToneMessage(pin.intValue(), value, (Integer)ToneController.this.durationSpinner.getValue());
                        } else {
                            ToneController.this.link.sendToneMessage(pin.intValue(), value);
                        }
                        ToneController.this.updateToneButtonText();
                    } else if (e.getStateChange() == 2) {
                        ToneController.this.link.sendNoToneMessage(pin.intValue());
                        ToneController.this.updateToneButtonText();
                    }
                }
            }
        });
        this.add(this.toneButton);
    }

    @Override
    public void setLink(Link link) {
        this.link = link;
    }

    public String getValueLabelOn() {
        return this.frequencyLabel.getText();
    }

    public void setValueLabelOn(String valueLabel) {
        this.frequencyLabel.setText(valueLabel);
    }

    public String getValueLabelOff() {
        return this.durationLabel.getText();
    }

    public void setValueLabelOff(String valueLabel) {
        this.durationLabel.setText(valueLabel);
    }

    public void setFrequency(int frequency) {
        this.frequencySpinner.setValue(frequency);
    }

    public int getFrequency() {
        return (Integer)this.frequencySpinner.getValue();
    }

    public void setDuration(int duration) {
        this.durationSpinner.setValue(duration);
    }

    public int getDuration() {
        return (Integer)this.durationSpinner.getValue();
    }

    public boolean isFrequencyVisible() {
        return this.frequencyPanel.isVisible();
    }

    public void setFrequencyVisible(boolean aFlag) {
        this.frequencyPanel.setVisible(aFlag);
    }

    public boolean isDurationVisible() {
        return this.durationPanel.isVisible();
    }

    public void setDurationVisible(boolean aFlag) {
        this.durationPanel.setVisible(aFlag);
    }

    public void setButtonTextOn(String text) {
        this.toneButtonOnText = text;
        this.updateToneButtonText();
    }

    public void setButtonTextOff(String text) {
        this.toneButtonOffText = text;
        this.updateToneButtonText();
    }

    private void updateToneButtonText() {
        if (this.toneButton.isSelected()) {
            this.toneButton.setText(this.toneButtonOnText);
        } else {
            this.toneButton.setText(this.toneButtonOffText);
        }
    }

    public void setIcon(Icon defaultIcon) {
        this.toneButton.setIcon(defaultIcon);
    }

    public void setPressedIcon(Icon pressedIcon) {
        this.toneButton.setPressedIcon(pressedIcon);
    }

    public void setSelectedIcon(Icon selectedIcon) {
        this.toneButton.setSelectedIcon(selectedIcon);
    }

    public void setRolloverIcon(Icon rolloverIcon) {
        this.toneButton.setRolloverIcon(rolloverIcon);
    }

    public void setRolloverSelectedIcon(Icon rolloverSelectedIcon) {
        this.toneButton.setRolloverSelectedIcon(rolloverSelectedIcon);
    }

    public void setDisabledIcon(Icon disabledIcon) {
        this.toneButton.setDisabledIcon(disabledIcon);
    }

    public void setDisabledSelectedIcon(Icon disabledSelectedIcon) {
        this.toneButton.setDisabledSelectedIcon(disabledSelectedIcon);
    }

    public void setIconTextGap(int iconTextGap) {
        this.toneButton.setIconTextGap(iconTextGap);
    }

    public void setRolloverEnabled(boolean b) {
        this.toneButton.setRolloverEnabled(b);
    }

    @Override
    public void setForeground(Color fg) {
        if (this.toneButton != null) {
            this.toneButton.setForeground(fg);
        }
    }

    @Override
    public void setBackground(Color bg) {
        if (this.toneButton != null) {
            this.toneButton.setBackground(bg);
        }
    }
}

