/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.gui.connectionpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.net.URI;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.ardulink.core.Link;
import org.ardulink.core.linkmanager.LinkManager;
import org.ardulink.gui.Linkable;
import org.ardulink.gui.connectionpanel.GenericPanelBuilder;
import org.ardulink.gui.connectionpanel.GridBagConstraintsBuilder;
import org.ardulink.gui.connectionpanel.PanelBuilder;
import org.ardulink.gui.connectionpanel.WaitDialog;
import org.ardulink.gui.facility.UtilityGeometry;
import org.ardulink.legacy.Link;
import org.ardulink.util.Lists;
import org.ardulink.util.Preconditions;
import org.ardulink.util.Throwables;

public class ConnectionPanel
extends JPanel
implements Linkable {
    private static final long serialVersionUID = 1290277902714226253L;
    private final JComboBox<String> uris = this.createURICombo();
    private final transient PanelBuilder fallback = new GenericPanelBuilder();
    private transient org.ardulink.legacy.Link link;
    private transient LinkManager.Configurer configurer;
    private JPanel panel;

    private JComboBox<String> createURICombo() {
        JComboBox<String> uris = new JComboBox<String>();
        uris.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 2756587449741341859L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return value == null ? null : super.getListCellRendererComponent((JList<?>)list, LinkManager.extractNameFromURI((URI)URI.create((String)value)), index, isSelected, cellHasFocus);
            }
        });
        uris.addItemListener(event -> {
            if (event.getStateChange() == 1) {
                this.replaceSubpanel();
            }
        });
        return uris;
    }

    public ConnectionPanel() {
        this.setLayout(new GridBagLayout());
        this.add((Component)new JLabel("Type"), GridBagConstraintsBuilder.constraints(0, 0).build());
        this.add(this.uris, GridBagConstraintsBuilder.constraints(0, 1).fillHorizontal().build());
        this.add(this.refreshButton(), GridBagConstraintsBuilder.constraints(0, 2).build());
        LinkManager linkManager = LinkManager.getInstance();
        for (URI uri : linkManager.listURIs()) {
            this.uris.addItem(uri.toASCIIString());
        }
    }

    private Component refreshButton() {
        JButton refreshButton = new JButton("refresh");
        refreshButton.addActionListener(e -> {
            if (this.uris.getItemCount() > 0) {
                this.replaceSubpanel();
            }
        });
        return refreshButton;
    }

    private void replaceSubpanel() {
        Component windowAncestor = SwingUtilities.getRoot(this);
        final WaitDialog waitDialog = new WaitDialog(windowAncestor instanceof Window ? (Window)windowAncestor : null);
        UtilityGeometry.setAlignmentCentered(waitDialog);
        new SwingWorker<JPanel, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    this.exchangePanel((JPanel)this.get());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    this.errorPanel(e);
                }
                finally {
                    ConnectionPanel.this.add((Component)ConnectionPanel.this.panel, GridBagConstraintsBuilder.constraints(1, 0).gridwidth(3).fillBoth().build());
                    2 e = this;
                    synchronized (e) {
                        waitDialog.dispose();
                    }
                }
            }

            private void errorPanel(Exception e) {
                JPanel newPanel = new JPanel();
                newPanel.setBackground(Color.RED);
                Throwable rootCause = Throwables.getRootCause((Throwable)e);
                newPanel.add(new JLabel(rootCause.getClass().getName() + ": " + rootCause.getMessage()));
                this.exchangePanel(newPanel);
                throw Throwables.propagate((Throwable)e);
            }

            private void exchangePanel(JPanel newPanel) {
                if (ConnectionPanel.this.panel != null) {
                    ConnectionPanel.this.remove(ConnectionPanel.this.panel);
                }
                ConnectionPanel.this.panel = newPanel;
                ConnectionPanel.this.add((Component)ConnectionPanel.this.panel, GridBagConstraintsBuilder.constraints(1, 0).fillBoth().build());
                ConnectionPanel.this.revalidate();
            }

            @Override
            protected JPanel doInBackground() {
                this.displayIn(waitDialog, 1, TimeUnit.SECONDS);
                return ConnectionPanel.this.createSubpanel();
            }

            private void displayIn(WaitDialog waitDialog2, int timeout, TimeUnit tu) {
                Executors.newCachedThreadPool().execute(() -> {
                    try {
                        tu.sleep(timeout);
                        2 var4_4 = this;
                        synchronized (var4_4) {
                            if (!this.isDone()) {
                                waitDialog2.setVisible(true);
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                });
            }
        }.execute();
    }

    private JPanel createSubpanel() {
        URI uri = URI.create(String.valueOf(this.uris.getSelectedItem()));
        this.configurer = LinkManager.getInstance().getConfigurer(uri);
        JPanel subpanel = this.findPanelBuilder(uri).createPanel(this.configurer);
        subpanel.setBorder(BorderFactory.createLoweredBevelBorder());
        return subpanel;
    }

    private PanelBuilder findPanelBuilder(URI uri) {
        for (PanelBuilder panelBuilder : Lists.newArrayList(ServiceLoader.load(PanelBuilder.class).iterator())) {
            if (!panelBuilder.canHandle(uri)) continue;
            return panelBuilder;
        }
        Preconditions.checkState((boolean)this.fallback.canHandle(uri), (String)"No PanelBuilder found for %s", (Object[])new Object[]{uri});
        return this.fallback;
    }

    public org.ardulink.legacy.Link createLink() {
        return this.configurer == null ? null : this.legacyAdapt(this.configurer.newLink());
    }

    private org.ardulink.legacy.Link legacyAdapt(Link link) {
        return new Link.LegacyLinkAdapter(link);
    }

    public org.ardulink.legacy.Link getLink() {
        return this.link;
    }

    @Override
    public void setLink(org.ardulink.legacy.Link newLink) {
        this.link = newLink;
    }
}

