/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.gui.connectionpanel;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.net.URI;
import java.util.Arrays;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.ardulink.core.linkmanager.LinkManager;
import org.ardulink.gui.connectionpanel.GridBagConstraintsBuilder;
import org.ardulink.gui.connectionpanel.PanelBuilder;
import org.ardulink.util.Numbers;
import org.ardulink.util.Primitives;

public class GenericPanelBuilder
implements PanelBuilder {
    @Override
    public boolean canHandle(URI uri) {
        return true;
    }

    @Override
    public JPanel createPanel(LinkManager.Configurer configurer) {
        JPanel panel = new JPanel(new GridBagLayout());
        int row = 0;
        for (String name : configurer.getAttributes()) {
            int col = 0;
            LinkManager.ConfigAttribute attribute = configurer.getAttribute(name);
            String description = attribute.getDescription();
            JLabel label = new JLabel(attribute.getName());
            label.setToolTipText(description);
            panel.add((Component)label, GridBagConstraintsBuilder.constraints(row, col++).build());
            boolean isDiscoverable = attribute.choiceDependsOn().length > 0;
            JComponent component = GenericPanelBuilder.createComponent(attribute);
            component.setToolTipText(description);
            panel.add((Component)component, GridBagConstraintsBuilder.constraints(row, col++).gridwidth(isDiscoverable ? 1 : 0).fillHorizontal().build());
            JComponent comp = isDiscoverable ? GenericPanelBuilder.createDiscoverButton(attribute, (JComboBox)component) : new JPanel();
            panel.add((Component)comp, GridBagConstraintsBuilder.constraints(row, col++).build());
            ++row;
        }
        panel.add((Component)new JPanel(), GridBagConstraintsBuilder.constraints(row++, 0).gridwidth(0).fillBoth().build());
        return panel;
    }

    private static JButton createDiscoverButton(LinkManager.ConfigAttribute attribute, JComboBox<Object> comboBox) {
        JButton discoverButton = new JButton(GenericPanelBuilder.loadIcon());
        discoverButton.setToolTipText("Discover");
        discoverButton.addActionListener(e -> comboBox.setModel(new DefaultComboBoxModel<Object>(attribute.getChoiceValues())));
        return discoverButton;
    }

    private static ImageIcon loadIcon() {
        return new ImageIcon(GenericPanelBuilder.class.getResource("icons/search_icon.png"));
    }

    private static JComponent createComponent(LinkManager.ConfigAttribute attribute) {
        if (GenericPanelBuilder.isBoolean(attribute)) {
            return GenericPanelBuilder.createCheckBox(attribute);
        }
        if (GenericPanelBuilder.isChoice(attribute)) {
            return GenericPanelBuilder.createComboxBox(attribute);
        }
        if (GenericPanelBuilder.isNumber(attribute)) {
            return GenericPanelBuilder.createSpinner(attribute);
        }
        return GenericPanelBuilder.createTextField(attribute);
    }

    private static JComponent createCheckBox(LinkManager.ConfigAttribute attribute) {
        JCheckBox checkBox = new JCheckBox();
        checkBox.addActionListener(e -> attribute.setValue((Object)checkBox.isSelected()));
        return GenericPanelBuilder.setState(checkBox, attribute);
    }

    private static JComponent createComboxBox(LinkManager.ConfigAttribute attribute) {
        JComboBox<Object> jComboBox = new JComboBox<Object>(attribute.getChoiceValues());
        if (attribute.getType().isEnum()) {
            ListCellRenderer<Object> delegate = jComboBox.getRenderer();
            jComboBox.setRenderer((list, value, index, isSelected, cellHasFocus) -> delegate.getListCellRendererComponent(list, value == null ? null : GenericPanelBuilder.resolveText(attribute, value), index, isSelected, cellHasFocus));
        }
        jComboBox.addActionListener(e -> attribute.setValue(jComboBox.getSelectedItem()));
        boolean nullIsAvalidItem = Arrays.asList(attribute.getChoiceValues()).contains(null);
        jComboBox.addPropertyChangeListener("model", pce -> GenericPanelBuilder.setSelection(jComboBox, attribute.getValue(), nullIsAvalidItem));
        GenericPanelBuilder.setSelection(jComboBox, attribute.getValue(), nullIsAvalidItem);
        return jComboBox;
    }

    private static Object resolveText(LinkManager.ConfigAttribute attribute, Object value) {
        String choiceDescription = attribute.getChoiceDescription(value);
        return choiceDescription == null ? value : choiceDescription;
    }

    private static JComponent createSpinner(LinkManager.ConfigAttribute attribute) {
        JSpinner spinner = new JSpinner(GenericPanelBuilder.createModel(attribute));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(spinner);
        editor.getTextField().setHorizontalAlignment(2);
        editor.getFormat().setGroupingUsed(false);
        spinner.setEditor(editor);
        spinner.setValue(attribute.getValue());
        spinner.addChangeListener(e -> attribute.setValue(spinner.getValue()));
        return spinner;
    }

    private static JComponent createTextField(final LinkManager.ConfigAttribute attribute) {
        Object value = attribute.getValue();
        final JTextField jTextField = new JTextField(value == null ? "" : String.valueOf(value));
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                attribute.setValue((Object)jTextField.getText());
            }
        });
        return jTextField;
    }

    private static SpinnerModel createModel(LinkManager.ConfigAttribute attribute) {
        LinkManager.ValidationInfo info = attribute.getValidationInfo();
        Class wrapped = Primitives.wrap((Class)attribute.getType());
        if (info instanceof LinkManager.NumberValidationInfo && Number.class.isAssignableFrom(wrapped)) {
            LinkManager.NumberValidationInfo numberValidationInfo = (LinkManager.NumberValidationInfo)info;
            Numbers targetType = Numbers.numberType((Class)wrapped);
            Number min = targetType.convert((Number)numberValidationInfo.min());
            Number max = targetType.convert((Number)numberValidationInfo.max());
            Number stepSize = targetType.convert((Number)1);
            return new SpinnerNumberModel(min, (Comparable)((Object)min), (Comparable)((Object)max), stepSize);
        }
        return new SpinnerNumberModel();
    }

    private static JComponent setState(JCheckBox checkBox, LinkManager.ConfigAttribute attribute) {
        checkBox.setSelected((Boolean)attribute.getValue());
        return checkBox;
    }

    private static void setSelection(JComboBox<Object> comboBox, Object value, boolean nullIsAvalidItem) {
        if (value == null) {
            if (nullIsAvalidItem) {
                comboBox.setSelectedIndex(-1);
            } else {
                GenericPanelBuilder.selectFirstValue(comboBox);
            }
        } else {
            comboBox.setSelectedItem(value);
        }
    }

    private static void selectFirstValue(JComboBox<Object> comboBox) {
        comboBox.setSelectedIndex(comboBox.getModel().getSize() > 0 ? 0 : -1);
    }

    private static boolean isChoice(LinkManager.ConfigAttribute attribute) {
        return attribute.hasChoiceValues();
    }

    private static boolean isBoolean(LinkManager.ConfigAttribute attribute) {
        return attribute.getType().equals(Boolean.class) || attribute.getType().equals(Boolean.TYPE);
    }

    private static boolean isNumber(LinkManager.ConfigAttribute attribute) {
        return Number.class.isAssignableFrom(Primitives.wrap((Class)attribute.getType()));
    }
}

