/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.gui.connectionpanel;

import java.awt.GridBagConstraints;
import java.awt.Insets;

public final class GridBagConstraintsBuilder {
    private final GridBagConstraints c = new GridBagConstraints();

    private GridBagConstraintsBuilder() {
    }

    public static GridBagConstraintsBuilder constraints(int row, int column) {
        return new GridBagConstraintsBuilder().row(row).column(column).anchor(21).insets(4, 4, 4, 4);
    }

    public GridBagConstraintsBuilder row(int row) {
        this.c.gridy = row;
        return this;
    }

    public GridBagConstraintsBuilder column(int column) {
        this.c.gridx = column;
        return this;
    }

    public GridBagConstraintsBuilder insets(int top, int left, int bottom, int right) {
        this.c.insets = new Insets(top, left, bottom, right);
        return this;
    }

    public GridBagConstraintsBuilder anchor(int anchor) {
        this.c.anchor = anchor;
        return this;
    }

    public GridBagConstraintsBuilder fillBoth() {
        return this.fillHorizontal().fillVertical().fill(1);
    }

    public GridBagConstraintsBuilder fillHorizontal() {
        return this.weightX(1).fill(2);
    }

    public GridBagConstraintsBuilder fillVertical() {
        return this.weightY(1).fill(3);
    }

    public GridBagConstraintsBuilder weightX(int weight) {
        this.c.weightx = weight;
        return this;
    }

    public GridBagConstraintsBuilder weightY(int weight) {
        this.c.weighty = weight;
        return this;
    }

    private GridBagConstraintsBuilder fill(int type) {
        this.c.fill = type;
        return this;
    }

    public GridBagConstraintsBuilder gridwidth(int width) {
        this.c.gridwidth = width;
        return this;
    }

    public GridBagConstraintsBuilder gridheight(int height) {
        this.c.gridheight = height;
        return this;
    }

    public GridBagConstraints build() {
        return this.c;
    }
}

