/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.gui.customcomponents;

import java.awt.BorderLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.ardulink.gui.Linkable;
import org.ardulink.gui.customcomponents.ToggleSignalButton;
import org.ardulink.legacy.Link;
import org.ardulink.util.Primitives;

public class ModifiableToggleSignalButton
extends JPanel
implements Linkable {
    private static final long serialVersionUID = 7024281203061769142L;
    private ToggleSignalButton signalButton = new ToggleSignalButton();
    private JCheckBox chckbxValueOnFieldIs;
    private JTextField columnsTextField;
    private JTextField buttonOnTextField;
    private JCheckBox chckbxValueOffFieldIs;
    private JTextField buttonOffTextField;
    private JTextField idTextField;

    public ModifiableToggleSignalButton() {
        this.setLayout(new BorderLayout(0, 0));
        JTabbedPane tabbedPane = new JTabbedPane(1);
        this.add(tabbedPane);
        tabbedPane.addTab("Play", null, this.signalButton, null);
        JPanel configPanel = new JPanel();
        tabbedPane.addTab("Configure", null, configPanel, null);
        configPanel.setLayout(null);
        this.chckbxValueOnFieldIs = new JCheckBox("Value field ON is visible");
        this.chckbxValueOnFieldIs.addChangeListener(e -> this.signalButton.setValueOnVisible(this.chckbxValueOnFieldIs.isSelected()));
        this.chckbxValueOnFieldIs.setSelected(true);
        this.chckbxValueOnFieldIs.setBounds(6, 8, 164, 18);
        configPanel.add(this.chckbxValueOnFieldIs);
        this.chckbxValueOffFieldIs = new JCheckBox("Value field OFF is visible");
        this.chckbxValueOffFieldIs.addChangeListener(e -> this.signalButton.setValueOffVisible(this.chckbxValueOffFieldIs.isSelected()));
        this.chckbxValueOffFieldIs.setSelected(true);
        this.chckbxValueOffFieldIs.setBounds(6, 34, 164, 18);
        configPanel.add(this.chckbxValueOffFieldIs);
        JLabel lblColumns = new JLabel("Columns:");
        lblColumns.setHorizontalAlignment(4);
        lblColumns.setBounds(6, 66, 80, 16);
        configPanel.add(lblColumns);
        this.columnsTextField = new JTextField();
        this.columnsTextField.setText("10");
        this.columnsTextField.setBounds(90, 60, 80, 28);
        configPanel.add(this.columnsTextField);
        this.columnsTextField.setColumns(10);
        this.columnsTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateColumns();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateColumns();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateColumns();
            }

            private void updateColumns() {
                Primitives.tryParseAs(Integer.class, (String)ModifiableToggleSignalButton.this.columnsTextField.getText()).ifPresent(v -> {
                    ModifiableToggleSignalButton.this.signalButton.setValueOnColumns((int)v);
                    ModifiableToggleSignalButton.this.signalButton.setValueOffColumns((int)v);
                });
            }
        });
        JLabel lblBtnOnText = new JLabel("Btn. ON Text:");
        lblBtnOnText.setHorizontalAlignment(4);
        lblBtnOnText.setBounds(6, 102, 80, 16);
        configPanel.add(lblBtnOnText);
        JLabel lblBtnOffText = new JLabel("Btn. OFF Text:");
        lblBtnOffText.setHorizontalAlignment(4);
        lblBtnOffText.setBounds(6, 138, 80, 16);
        configPanel.add(lblBtnOffText);
        this.buttonOnTextField = new JTextField();
        this.buttonOnTextField.setText("Send");
        this.buttonOnTextField.setColumns(10);
        this.buttonOnTextField.setBounds(90, 96, 80, 28);
        configPanel.add(this.buttonOnTextField);
        this.buttonOnTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateButtonLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateButtonLabel();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateButtonLabel();
            }

            private void updateButtonLabel() {
                ModifiableToggleSignalButton.this.signalButton.setButtonTextOn(ModifiableToggleSignalButton.this.buttonOnTextField.getText());
            }
        });
        this.buttonOffTextField = new JTextField();
        this.buttonOffTextField.setText("Send");
        this.buttonOffTextField.setColumns(10);
        this.buttonOffTextField.setBounds(90, 132, 80, 28);
        configPanel.add(this.buttonOffTextField);
        this.buttonOffTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateButtonLabel();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateButtonLabel();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateButtonLabel();
            }

            private void updateButtonLabel() {
                ModifiableToggleSignalButton.this.signalButton.setButtonTextOff(ModifiableToggleSignalButton.this.buttonOffTextField.getText());
            }
        });
        JLabel lblId = new JLabel("Id:");
        lblId.setHorizontalAlignment(4);
        lblId.setBounds(6, 174, 80, 16);
        configPanel.add(lblId);
        this.idTextField = new JTextField();
        this.idTextField.setText("ID");
        this.idTextField.setColumns(10);
        this.idTextField.setBounds(90, 168, 80, 28);
        configPanel.add(this.idTextField);
        this.idTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateId();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateId();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateId();
            }

            private void updateId() {
                ModifiableToggleSignalButton.this.signalButton.setId(ModifiableToggleSignalButton.this.idTextField.getText());
            }
        });
        this.signalButton.setValueOnColumns(Integer.parseInt(this.columnsTextField.getText()));
        this.signalButton.setButtonTextOn(this.buttonOnTextField.getText());
        this.signalButton.setButtonTextOff(this.buttonOffTextField.getText());
        this.signalButton.setId(this.idTextField.getText());
    }

    @Override
    public void setLink(Link link) {
        this.signalButton.setLink(link);
    }

    public ToggleSignalButton getSignalButton() {
        return this.signalButton;
    }

    public void setValueOn(String t) {
        this.signalButton.setValueOn(t);
    }

    public void setValueOff(String t) {
        this.signalButton.setValueOff(t);
    }

    public String getValueOn() {
        return this.signalButton.getValueOn();
    }

    public String getValueOff() {
        return this.signalButton.getValueOff();
    }

    public boolean isValueOnVisible() {
        return this.signalButton.isValueOnVisible();
    }

    public boolean isValueOffVisible() {
        return this.signalButton.isValueOffVisible();
    }

    public void setValueOnVisible(boolean aFlag) {
        this.chckbxValueOnFieldIs.setSelected(aFlag);
    }

    public void setValueOffVisible(boolean aFlag) {
        this.chckbxValueOffFieldIs.setSelected(aFlag);
    }

    public void setValueColumns(int columns) {
        this.columnsTextField.setText(String.valueOf(columns));
    }

    public void setButtonOnText(String text) {
        this.buttonOnTextField.setText(text);
    }

    public void setButtonOffText(String text) {
        this.buttonOffTextField.setText(text);
    }

    public String getId() {
        return this.signalButton.getId();
    }

    public void setId(String id) {
        this.idTextField.setText(id);
    }
}

