/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.gui.customcomponents;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.ardulink.gui.Linkable;
import org.ardulink.legacy.Link;

public class SignalButton
extends JPanel
implements Linkable {
    private static final long serialVersionUID = -5162326079507604871L;
    private transient Link link;
    private JTextField textField;
    private JButton signalButton;
    private JPanel valuePanel;
    private String id = "none";
    private JLabel valueLabel;

    public SignalButton() {
        this.setLayout(new BorderLayout(0, 0));
        this.signalButton = new JButton("Send");
        this.signalButton.addActionListener(e -> this.link.sendCustomMessage(new String[]{this.getId(), this.getValue()}));
        this.add(this.signalButton);
        this.valuePanel = new JPanel();
        this.add((Component)this.valuePanel, "North");
        this.valueLabel = new JLabel("Value:");
        this.valuePanel.add(this.valueLabel);
        this.textField = new JTextField();
        this.valuePanel.add(this.textField);
        this.textField.setColumns(10);
        this.textField.setMinimumSize(this.getPreferredSize());
    }

    @Override
    public void setLink(Link link) {
        this.link = link;
    }

    public String getValueLabel() {
        return this.valueLabel.getText();
    }

    public void setValueLabel(String valueLabel) {
        this.valueLabel.setText(valueLabel);
    }

    public void setValue(String t) {
        this.textField.setText(t);
    }

    public String getValue() {
        return this.textField.getText();
    }

    public boolean isValueVisible() {
        return this.valuePanel.isVisible();
    }

    public void setValueVisible(boolean aFlag) {
        this.valuePanel.setVisible(aFlag);
    }

    public void setValueColumns(int columns) {
        this.textField.setColumns(columns);
    }

    public void setButtonText(String text) {
        this.signalButton.setText(text);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIcon(Icon defaultIcon) {
        this.signalButton.setIcon(defaultIcon);
    }

    public void setPressedIcon(Icon pressedIcon) {
        this.signalButton.setPressedIcon(pressedIcon);
    }

    public void setSelectedIcon(Icon selectedIcon) {
        this.signalButton.setSelectedIcon(selectedIcon);
    }

    public void setRolloverIcon(Icon rolloverIcon) {
        this.signalButton.setRolloverIcon(rolloverIcon);
    }

    public void setRolloverSelectedIcon(Icon rolloverSelectedIcon) {
        this.signalButton.setRolloverSelectedIcon(rolloverSelectedIcon);
    }

    public void setDisabledIcon(Icon disabledIcon) {
        this.signalButton.setDisabledIcon(disabledIcon);
    }

    public void setDisabledSelectedIcon(Icon disabledSelectedIcon) {
        this.signalButton.setDisabledSelectedIcon(disabledSelectedIcon);
    }

    public void setIconTextGap(int iconTextGap) {
        this.signalButton.setIconTextGap(iconTextGap);
    }

    public void setRolloverEnabled(boolean b) {
        this.signalButton.setRolloverEnabled(b);
    }

    @Override
    public void setForeground(Color fg) {
        if (this.signalButton != null) {
            this.signalButton.setForeground(fg);
        }
    }

    @Override
    public void setBackground(Color bg) {
        if (this.signalButton != null) {
            this.signalButton.setBackground(bg);
        }
    }
}

