/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.gui.customcomponents;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.ardulink.gui.Linkable;
import org.ardulink.legacy.Link;

public class ToggleSignalButton
extends JPanel
implements Linkable {
    private static final long serialVersionUID = -5162326079507604871L;
    private transient Link link;
    private JTextField textFieldOn;
    private JToggleButton signalButton;
    private JPanel valuePanelOn;
    private String id = "none";
    private JLabel valueLabelOn;
    private JPanel configPanel;
    private JPanel valuePanelOff;
    private JLabel valueLabelOff;
    private JTextField textFieldOff;
    private String signalButtonOnText = "On";
    private String signalButtonOffText = "Off";

    public ToggleSignalButton() {
        this.setLayout(new BorderLayout(0, 0));
        this.configPanel = new JPanel();
        this.add((Component)this.configPanel, "North");
        this.configPanel.setLayout(new BoxLayout(this.configPanel, 1));
        this.valuePanelOn = new JPanel();
        this.configPanel.add(this.valuePanelOn);
        this.valuePanelOn.setLayout(new BoxLayout(this.valuePanelOn, 0));
        this.valueLabelOn = new JLabel("Value on:");
        this.valueLabelOn.setHorizontalAlignment(4);
        this.valuePanelOn.add(this.valueLabelOn);
        this.textFieldOn = new JTextField();
        this.valuePanelOn.add(this.textFieldOn);
        this.textFieldOn.setColumns(10);
        this.valuePanelOff = new JPanel();
        this.configPanel.add(this.valuePanelOff);
        this.valuePanelOff.setLayout(new BoxLayout(this.valuePanelOff, 0));
        this.valueLabelOff = new JLabel("Value off:");
        this.valueLabelOff.setHorizontalAlignment(4);
        this.valuePanelOff.add(this.valueLabelOff);
        this.textFieldOff = new JTextField();
        this.textFieldOff.setColumns(10);
        this.valuePanelOff.add(this.textFieldOff);
        this.signalButton = new JToggleButton("Off");
        this.signalButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ToggleSignalButton.this.link.sendCustomMessage(new String[]{ToggleSignalButton.this.getId(), e.getStateChange() == 1 ? ToggleSignalButton.this.getValueOn() : ToggleSignalButton.this.getValueOff()});
                ToggleSignalButton.this.updateSignalButtonText();
            }
        });
        this.add(this.signalButton);
    }

    @Override
    public void setLink(Link link) {
        this.link = link;
    }

    public String getValueLabelOn() {
        return this.valueLabelOn.getText();
    }

    public void setValueLabelOn(String valueLabel) {
        this.valueLabelOn.setText(valueLabel);
    }

    public String getValueLabelOff() {
        return this.valueLabelOff.getText();
    }

    public void setValueLabelOff(String valueLabel) {
        this.valueLabelOff.setText(valueLabel);
    }

    public void setValueOn(String t) {
        this.textFieldOn.setText(t);
    }

    public String getValueOn() {
        return this.textFieldOn.getText();
    }

    public void setValueOff(String t) {
        this.textFieldOff.setText(t);
    }

    public String getValueOff() {
        return this.textFieldOff.getText();
    }

    public boolean isValueOnVisible() {
        return this.valuePanelOn.isVisible();
    }

    public void setValueOnVisible(boolean aFlag) {
        this.valuePanelOn.setVisible(aFlag);
    }

    public boolean isValueOffVisible() {
        return this.valuePanelOff.isVisible();
    }

    public void setValueOffVisible(boolean aFlag) {
        this.valuePanelOff.setVisible(aFlag);
    }

    public void setValueOnColumns(int columns) {
        this.textFieldOn.setColumns(columns);
    }

    public void setValueOffColumns(int columns) {
        this.textFieldOff.setColumns(columns);
    }

    public void setButtonTextOn(String text) {
        this.signalButtonOnText = text;
        this.updateSignalButtonText();
    }

    public void setButtonTextOff(String text) {
        this.signalButtonOffText = text;
        this.updateSignalButtonText();
    }

    private void updateSignalButtonText() {
        if (this.signalButton.isSelected()) {
            this.signalButton.setText(this.signalButtonOnText);
        } else {
            this.signalButton.setText(this.signalButtonOffText);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIcon(Icon defaultIcon) {
        this.signalButton.setIcon(defaultIcon);
    }

    public void setPressedIcon(Icon pressedIcon) {
        this.signalButton.setPressedIcon(pressedIcon);
    }

    public void setSelectedIcon(Icon selectedIcon) {
        this.signalButton.setSelectedIcon(selectedIcon);
    }

    public void setRolloverIcon(Icon rolloverIcon) {
        this.signalButton.setRolloverIcon(rolloverIcon);
    }

    public void setRolloverSelectedIcon(Icon rolloverSelectedIcon) {
        this.signalButton.setRolloverSelectedIcon(rolloverSelectedIcon);
    }

    public void setDisabledIcon(Icon disabledIcon) {
        this.signalButton.setDisabledIcon(disabledIcon);
    }

    public void setDisabledSelectedIcon(Icon disabledSelectedIcon) {
        this.signalButton.setDisabledSelectedIcon(disabledSelectedIcon);
    }

    public void setIconTextGap(int iconTextGap) {
        this.signalButton.setIconTextGap(iconTextGap);
    }

    public void setRolloverEnabled(boolean b) {
        this.signalButton.setRolloverEnabled(b);
    }

    @Override
    public void setForeground(Color fg) {
        if (this.signalButton != null) {
            this.signalButton.setForeground(fg);
        }
    }

    @Override
    public void setBackground(Color bg) {
        if (this.signalButton != null) {
            this.signalButton.setBackground(bg);
        }
    }
}

