/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.gui.customcomponents.joystick;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.ardulink.gui.Linkable;
import org.ardulink.gui.event.PositionEvent;
import org.ardulink.gui.event.PositionListener;
import org.ardulink.legacy.Link;

public class Joystick
extends JPanel
implements Linkable {
    private transient Link link;
    private final List<PositionListener> positionListeners = new ArrayList<PositionListener>();
    private String id = "none";
    private static final int BORDER_SIZE = 40;
    private static final long serialVersionUID = 3725139510642524282L;
    private int joyOutputRange;
    private float joySize;
    private float joyWidth;
    private float joyHeight;
    private float joyCenterX;
    private float joyCenterY;
    private float curJoyAngle;
    private float curJoySize;
    private boolean isMouseTracking;
    private boolean leftMouseButton;
    private int mouseX;
    private int mouseY;
    private transient Stroke lineStroke = new BasicStroke(10.0f, 1, 1);
    private final Point position;

    public Joystick() {
        this(255, 128);
    }

    public Joystick(int joyOutputRange, int joySize) {
        this.joyOutputRange = joyOutputRange;
        this.position = new Point();
        this.setJoySize(joySize);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Joystick.this.leftMouseButton = SwingUtilities.isLeftMouseButton(e);
                Joystick.this.mouseCheck(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Joystick.this.mouseRestore();
            }
        };
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.setInternalSize(width, height);
    }

    public void setInternalSize(float width, float height) {
        this.joyHeight = this.joyWidth = Math.min(width, height) - 40.0f;
        this.joyCenterX = width / 2.0f;
        this.joyCenterY = height;
        this.setJoySize(this.joyWidth);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.setInternalSize(width, height);
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.setInternalSize(r.width, r.height);
    }

    private void mouseCheck(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        float dx = (float)this.mouseX - this.joyCenterX;
        float dy = (float)this.mouseY - this.joyCenterY;
        this.isMouseTracking = this.leftMouseButton;
        if (this.isMouseTracking) {
            this.curJoyAngle = (float)Math.atan2(dy, dx);
            this.curJoySize = (float)Point2D.distance(this.mouseX, this.mouseY, this.joyCenterX, this.joyCenterY);
        } else {
            this.curJoySize = 0.0f;
        }
        if (this.curJoySize > this.joySize) {
            this.curJoySize = this.joySize;
        }
        this.position.x = (int)((double)this.joyOutputRange * (Math.cos(this.curJoyAngle) * (double)this.curJoySize) / (double)this.joySize);
        this.position.y = (int)((double)this.joyOutputRange * (-(Math.sin(this.curJoyAngle) * (double)this.curJoySize) / (double)this.joySize));
        this.repaint();
        this.callPositionListeners();
        this.sendMessage();
    }

    private void mouseRestore() {
        this.leftMouseButton = false;
        this.position.x = 0;
        this.position.y = 0;
        this.mouseX = 0;
        this.mouseY = 0;
        this.curJoyAngle = 0.0f;
        this.curJoySize = 0.0f;
        this.repaint();
        this.callPositionListeners();
        this.sendMessage();
    }

    private void callPositionListeners() {
        PositionEvent event = new PositionEvent(new Point(this.position), this.joyOutputRange, this.id);
        for (PositionListener positionListener : this.positionListeners) {
            positionListener.positionChanged(event);
        }
    }

    private void sendMessage() {
        if (this.link != null) {
            this.link.sendCustomMessage(new String[]{this.getId(), String.valueOf(this.getValueX()), String.valueOf(this.getValueY())});
        }
    }

    private int getValueX() {
        return this.position.x;
    }

    private int getValueY() {
        return this.position.y;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.LIGHT_GRAY);
        g2.fillOval((int)(this.joyCenterX - this.joyWidth / 2.0f), (int)(this.joyCenterY - this.joyHeight / 2.0f), (int)this.joyWidth, (int)this.joyHeight);
        Graphics2D g3 = (Graphics2D)g2.create();
        g3.translate(this.joyCenterX, this.joyCenterY);
        g3.rotate(this.curJoyAngle);
        g3.setColor(Color.GRAY);
        g3.setStroke(this.lineStroke);
        g3.drawLine(0, 0, (int)this.curJoySize, 0);
        g3.dispose();
        g2.setColor(Color.GRAY);
        g2.fillOval((int)this.joyCenterX - 10, (int)this.joyCenterY - 10, 20, 20);
    }

    public Point getPosition() {
        return this.position;
    }

    @Override
    public void setLink(Link link) {
        this.link = link;
    }

    public boolean addPositionListener(PositionListener positionListener) {
        return this.positionListeners.add(positionListener);
    }

    public boolean removePositionListener(PositionListener positionListener) {
        return this.positionListeners.remove(positionListener);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getJoyOutputRange() {
        return this.joyOutputRange;
    }

    public void setJoyOutputRange(int joyOutputRange) {
        this.joyOutputRange = joyOutputRange;
    }

    public float getJoySize() {
        return this.joySize;
    }

    public void setJoySize(float joySize) {
        this.joySize = joySize;
        this.joyHeight = this.joyWidth = joySize;
        this.setPreferredSize(new Dimension((int)this.joyWidth + 40, (int)this.joyHeight + 40));
        this.joyCenterX = (float)this.getSize().width / 2.0f;
        this.joyCenterY = (float)this.getSize().height / 2.0f;
        this.joySize = this.joyWidth / 2.0f;
    }
}

