/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.gui.customcomponents.joystick;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.ardulink.gui.Linkable;
import org.ardulink.gui.customcomponents.joystick.Joystick;
import org.ardulink.gui.event.PositionEvent;
import org.ardulink.gui.event.PositionListener;
import org.ardulink.legacy.Link;

public class ModifiableJoystick
extends JPanel
implements Linkable,
PositionListener {
    private static final long serialVersionUID = -7958194636043905634L;
    private Joystick joy;
    private JTextField idTextField;
    private JLabel horizontalLabel;
    private JLabel verticalLabel;

    public ModifiableJoystick() {
        this.setLayout(new BorderLayout(0, 0));
        JPanel coordinatePanel = new JPanel();
        this.add((Component)coordinatePanel, "North");
        coordinatePanel.setLayout(new GridLayout(0, 1, 0, 0));
        this.horizontalLabel = new JLabel("Horizontal: 0");
        coordinatePanel.add(this.horizontalLabel);
        this.verticalLabel = new JLabel("Vertical: 0");
        coordinatePanel.add(this.verticalLabel);
        this.joy = new Joystick();
        this.add((Component)this.joy, "Center");
        JPanel idPanel = new JPanel();
        this.add((Component)idPanel, "South");
        JLabel lblId = new JLabel("ID:");
        idPanel.add(lblId);
        this.idTextField = new JTextField();
        this.idTextField.setText("none");
        this.idTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ModifiableJoystick.this.joy.setId(ModifiableJoystick.this.idTextField.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ModifiableJoystick.this.joy.setId(ModifiableJoystick.this.idTextField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ModifiableJoystick.this.joy.setId(ModifiableJoystick.this.idTextField.getText());
            }
        });
        idPanel.add(this.idTextField);
        this.idTextField.setColumns(10);
        JLabel lblMaxValue = new JLabel("Max Value:");
        idPanel.add(lblMaxValue);
        JSpinner maxValueSpinner = new JSpinner();
        maxValueSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSpinner spinner = (JSpinner)e.getSource();
                ModifiableJoystick.this.joy.setJoyOutputRange((Integer)spinner.getValue());
            }
        });
        maxValueSpinner.setModel(new SpinnerNumberModel((Number)255, Integer.valueOf(1), null, (Number)1));
        ((JSpinner.DefaultEditor)maxValueSpinner.getEditor()).getTextField().setColumns(4);
        idPanel.add(maxValueSpinner);
        this.joy.addPositionListener(this);
    }

    @Override
    public void setLink(Link link) {
        this.joy.setLink(link);
    }

    public boolean addPositionListener(PositionListener positionListener) {
        return this.joy.addPositionListener(positionListener);
    }

    public boolean removePositionListener(PositionListener positionListener) {
        return this.joy.removePositionListener(positionListener);
    }

    @Override
    public void positionChanged(PositionEvent e) {
        this.horizontalLabel.setText("Horizontal: " + e.getPosition().x);
        this.verticalLabel.setText("Vertical: " + e.getPosition().y);
    }

    public void setId(String id) {
        this.idTextField.setText(id);
    }

    public String getId() {
        return this.idTextField.getText();
    }
}

