/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.gui.customcomponents.joystick;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import org.ardulink.gui.event.PositionEvent;
import org.ardulink.gui.event.PositionListener;

public class SimplePositionListener
extends JPanel
implements PositionListener {
    private static final long serialVersionUID = -315437517373209646L;
    private Point position;
    private int internalMaxSize = 1;
    private static final int POINT_DIM = 15;

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.RED);
        int x = 0;
        int y = 0;
        Dimension dimension = this.getSize();
        int dim = Math.min(dimension.width, dimension.height) / 2;
        if (this.position != null) {
            x = this.position.x * dim / this.internalMaxSize;
            y = this.position.y * dim / this.internalMaxSize;
        }
        g2.fillOval(dimension.width / 2 + x - 7, dimension.height / 2 - y - 7, 15, 15);
    }

    @Override
    public void positionChanged(PositionEvent e) {
        this.position = e.getPosition();
        this.internalMaxSize = e.getMaxSize();
        this.repaint();
    }
}

