/*
 * Decompiled with CFR 0.152.
 */
package org.ardulink.gui.serial;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.ardulink.core.Connection;
import org.ardulink.core.ConnectionBasedLink;
import org.ardulink.core.Link;
import org.ardulink.core.qos.QosLink;
import org.ardulink.gui.Linkable;
import org.ardulink.util.Throwables;

public class SerialMonitor
extends JPanel
implements Linkable {
    private static final long serialVersionUID = -3662905914867077959L;
    private JTextArea sentTextArea;
    private JTextArea receivedTextArea;
    private JTextField messageTextField;
    private transient ConnectionBasedLink link;
    private final transient Connection.Listener listener = new Connection.Listener(){

        public void received(byte[] bytes) throws IOException {
            SerialMonitor.this.receivedTextArea.append("\n" + new String(bytes, StandardCharsets.UTF_8));
        }

        public void sent(byte[] bytes) throws IOException {
            SerialMonitor.this.sentTextArea.append(new String(bytes, StandardCharsets.UTF_8));
        }
    };

    public SerialMonitor() {
        this.setPreferredSize(new Dimension(640, 315));
        this.setLayout(new BorderLayout(0, 0));
        JPanel sendPanel = new JPanel();
        this.add((Component)sendPanel, "North");
        sendPanel.setLayout(new BorderLayout(0, 0));
        this.messageTextField = new JTextField();
        sendPanel.add((Component)this.messageTextField, "Center");
        this.messageTextField.setColumns(10);
        JButton sendButton = new JButton("Send");
        sendButton.addActionListener(e -> {
            try {
                this.link.getConnection().write((this.messageTextField.getText() + "\n").getBytes());
            }
            catch (IOException e1) {
                Throwables.propagate((Throwable)e1);
            }
        });
        sendPanel.add((Component)sendButton, "East");
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOrientation(0);
        this.add(splitPane);
        JPanel sentPanel = new JPanel();
        sentPanel.setPreferredSize(new Dimension(640, 200));
        splitPane.setLeftComponent(sentPanel);
        sentPanel.setLayout(new BorderLayout(0, 0));
        JLabel sentLabel = new JLabel("Sent:");
        sentPanel.add((Component)sentLabel, "North");
        JScrollPane sentScrollPane = new JScrollPane();
        sentPanel.add((Component)sentScrollPane, "Center");
        this.sentTextArea = new JTextArea();
        this.sentTextArea.setEditable(false);
        sentScrollPane.setViewportView(this.sentTextArea);
        JPanel receivedPanel = new JPanel();
        receivedPanel.setPreferredSize(new Dimension(640, 200));
        splitPane.setRightComponent(receivedPanel);
        receivedPanel.setLayout(new BorderLayout(0, 0));
        JLabel receivedLabel = new JLabel("Received:");
        receivedPanel.add((Component)receivedLabel, "North");
        JScrollPane receivedScrollPane = new JScrollPane();
        receivedPanel.add((Component)receivedScrollPane, "Center");
        this.receivedTextArea = new JTextArea();
        this.receivedTextArea.setEditable(false);
        receivedScrollPane.setViewportView(this.receivedTextArea);
        splitPane.setDividerLocation(0.5);
        JPanel buttonPanel = new JPanel();
        FlowLayout flowLayout = (FlowLayout)buttonPanel.getLayout();
        flowLayout.setAlignment(2);
        this.add((Component)buttonPanel, "South");
        JButton clearSentButton = new JButton("Clear Sent");
        clearSentButton.addActionListener(e -> this.sentTextArea.setText(""));
        buttonPanel.add(clearSentButton);
        JButton clearReceivedButton = new JButton("Clear Received");
        clearReceivedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SerialMonitor.this.receivedTextArea.setText("");
            }
        });
        buttonPanel.add(clearReceivedButton);
    }

    @Override
    public void setLink(org.ardulink.legacy.Link link) {
        if (this.link != null) {
            this.link.getConnection().removeListener(this.listener);
            this.link = null;
        }
        if (link == null) {
            this.link = null;
        } else {
            Link delegate = link.getDelegate();
            if (delegate instanceof QosLink) {
                delegate = ((QosLink)delegate).getDelegate();
            }
            if (delegate instanceof ConnectionBasedLink) {
                this.link = (ConnectionBasedLink)delegate;
                this.link.getConnection().addListener(this.listener);
            }
        }
        this.sentTextArea.setText("");
        this.receivedTextArea.setText("");
    }
}

