/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.container.chameleon.deployment.api;

import java.lang.annotation.Annotation;
import org.arquillian.container.chameleon.deployment.api.DeploymentParameters;
import org.arquillian.container.chameleon.deployment.api.IgnorePlaceholderException;
import org.jboss.arquillian.container.test.api.DeploymentConfiguration;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.shrinkwrap.api.Archive;

public class DeploymentConfigurationPopulator {
    public static DeploymentConfiguration.DeploymentContentBuilder populate(TestClass testClass, Archive<?> archive) {
        DeploymentParameters deploymentParameters = DeploymentConfigurationPopulator.resolveDeployment(testClass);
        DeploymentConfiguration.DeploymentContentBuilder deploymentContentBuilder = new DeploymentConfiguration.DeploymentContentBuilder(archive);
        DeploymentConfiguration.DeploymentBuilder deploymentBuilder = deploymentContentBuilder.withDeployment().withManaged(deploymentParameters.managed()).withOrder(deploymentParameters.order()).withTestable(deploymentParameters.testable());
        if (DeploymentConfigurationPopulator.isNotEmptyOrNull(deploymentParameters.deploymentName())) {
            deploymentBuilder.withName(deploymentParameters.deploymentName());
        }
        deploymentContentBuilder = deploymentBuilder.build();
        if (DeploymentConfigurationPopulator.isNotEmptyOrNull(deploymentParameters.overProtocol())) {
            deploymentContentBuilder.withOverProtocol(deploymentParameters.overProtocol());
        }
        if (DeploymentConfigurationPopulator.isNotEmptyOrNull(deploymentParameters.targetsContainer())) {
            deploymentContentBuilder.withTargetsContainer(deploymentParameters.targetsContainer());
        }
        if (deploymentParameters.shouldThrowExcetionClass() != IgnorePlaceholderException.class) {
            deploymentContentBuilder.withShouldThrowException(deploymentParameters.shouldThrowExcetionClass(), deploymentParameters.testable());
        }
        return deploymentContentBuilder;
    }

    private static DeploymentParameters resolveDeployment(TestClass testClass) {
        if (testClass.isAnnotationPresent(DeploymentParameters.class)) {
            return (DeploymentParameters)testClass.getAnnotation(DeploymentParameters.class);
        }
        return new DeploymentParametersAnnotationClass();
    }

    private static boolean isNotEmptyOrNull(String value) {
        return value != null && value.length() > 0;
    }

    static class DeploymentParametersAnnotationClass
    implements DeploymentParameters {
        DeploymentParametersAnnotationClass() {
        }

        @Override
        public String deploymentName() {
            return "";
        }

        @Override
        public boolean testable() {
            return true;
        }

        @Override
        public boolean managed() {
            return true;
        }

        @Override
        public int order() {
            return -1;
        }

        @Override
        public String overProtocol() {
            return "";
        }

        @Override
        public String targetsContainer() {
            return "";
        }

        @Override
        public Class<? extends Exception> shouldThrowExcetionClass() {
            return IgnorePlaceholderException.class;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return DeploymentParameters.class;
        }
    }
}

